/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.asterix.common.annotations.IndexedNLJoinExpressionAnnotation;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.cost.Cost;
import org.apache.asterix.optimizer.cost.ICost;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.IntroduceJoinAccessMethodRule;
import org.apache.asterix.optimizer.rules.am.IntroduceSelectAccessMethodRule;
import org.apache.asterix.optimizer.rules.cbo.JoinCondition;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.asterix.optimizer.rules.cbo.PlanNode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.PredicateCardinalityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoinNode {
    private static final Logger LOGGER = LogManager.getLogger();
    protected JoinEnum joinEnum;
    protected int jnArrayIndex;
    protected int datasetBits;
    protected List<Integer> datasetIndexes;
    protected List<String> datasetNames;
    protected List<String> aliases;
    protected int cheapestPlanIndex;
    protected ICost cheapestPlanCost;
    protected double origCardinality;
    protected double cardinality;
    protected double size;
    protected List<Integer> planIndexesArray;
    protected int jnIndex;
    protected int level;
    protected int highestDatasetId;
    protected JoinNode rightJn;
    protected JoinNode leftJn;
    protected List<Integer> applicableJoinConditions;
    protected EmptyTupleSourceOperator correspondingEmptyTupleSourceOp;
    protected List<Pair<IAccessMethod, Index>> chosenIndexes;
    protected Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs;
    protected Index.SampleIndexDetails idxDetails;
    protected static int NO_JN = -1;
    protected static int NO_CARDS = -2;

    public JoinNode(int i) {
        this.jnArrayIndex = i;
        this.planIndexesArray = new ArrayList<Integer>();
        this.cheapestPlanIndex = PlanNode.NO_PLAN;
        this.size = 1.0;
    }

    public JoinNode(int i, JoinEnum joinE) {
        this(i);
        this.joinEnum = joinE;
        this.cheapestPlanCost = this.joinEnum.getCostHandle().maxCost();
    }

    public boolean IsBaseLevelJoinNode() {
        return this.jnArrayIndex <= this.joinEnum.numberOfTerms;
    }

    public boolean IsHigherLevelJoinNode() {
        return !this.IsBaseLevelJoinNode();
    }

    public double computeJoinCardinality() {
        JoinNode[] jnArray = this.joinEnum.getJnArray();
        List<JoinCondition> joinConditions = this.joinEnum.getJoinConditions();
        this.applicableJoinConditions = new ArrayList<Integer>();
        this.findApplicableJoinConditions();
        if (LOGGER.isTraceEnabled() && this.applicableJoinConditions.size() == 0) {
            LOGGER.trace("applicable Join Conditions size is 0 in join Node " + this.jnArrayIndex);
        }
        double productJoinCardinality = 1.0;
        for (int idx : this.datasetIndexes) {
            productJoinCardinality *= jnArray[idx].cardinality;
        }
        double productJoinSels = 1.0;
        for (int idx : this.applicableJoinConditions) {
            if (joinConditions.get((int)idx).partOfComposite) continue;
            productJoinSels *= joinConditions.get((int)idx).selectivity;
        }
        return productJoinCardinality * productJoinSels;
    }

    public double getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(double card) {
        this.cardinality = card;
    }

    public double getOrigCardinality() {
        return this.origCardinality;
    }

    public void setOrigCardinality(double card) {
        this.origCardinality = card;
    }

    public void setAvgDocSize(double avgDocSize) {
        this.size = avgDocSize;
    }

    public double getInputSize() {
        return this.size;
    }

    public double getOutputSize() {
        return this.size;
    }

    public JoinNode getLeftJn() {
        return this.leftJn;
    }

    public JoinNode getRightJn() {
        return this.rightJn;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getDatasetNames() {
        return this.datasetNames;
    }

    public Index.SampleIndexDetails getIdxDetails() {
        return this.idxDetails;
    }

    protected boolean nestedLoopsApplicable(ILogicalExpression joinExpr) throws AlgebricksException {
        ArrayList usedVarList = new ArrayList();
        joinExpr.getUsedVariables(usedVarList);
        if (usedVarList.size() != 2) {
            return false;
        }
        if (joinExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        LogicalVariable var0 = (LogicalVariable)usedVarList.get(0);
        LogicalVariable var1 = (LogicalVariable)usedVarList.get(1);
        ILogicalOperator joinLeafInput0 = this.joinEnum.findLeafInput(Collections.singletonList(var0));
        if (joinLeafInput0 == null) {
            return false;
        }
        ILogicalOperator joinLeafInput1 = this.joinEnum.findLeafInput(Collections.singletonList(var1));
        if (joinLeafInput1 == null) {
            return false;
        }
        ILogicalOperator innerLeafInput = this.joinEnum.joinLeafInputsHashMap.get(this.correspondingEmptyTupleSourceOp);
        if (innerLeafInput != joinLeafInput1 && innerLeafInput != joinLeafInput0) {
            return false;
        }
        if (innerLeafInput == joinLeafInput0) {
            ((Mutable)this.joinEnum.localJoinOp.getInputs().get(0)).setValue((Object)joinLeafInput1);
        } else {
            ((Mutable)this.joinEnum.localJoinOp.getInputs().get(0)).setValue((Object)joinLeafInput0);
        }
        ((Mutable)this.joinEnum.localJoinOp.getInputs().get(1)).setValue((Object)innerLeafInput);
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)this.joinEnum.localJoinOp;
        joinOp.getCondition().setValue((Object)joinExpr);
        IntroduceJoinAccessMethodRule tmp = new IntroduceJoinAccessMethodRule();
        boolean retVal = tmp.checkApplicable((Mutable<ILogicalOperator>)new MutableObject((Object)this.joinEnum.localJoinOp), this.joinEnum.optCtx);
        return retVal;
    }

    private boolean subset(int one, int two) {
        return (one & two) == one;
    }

    protected void findApplicableJoinConditions() {
        List<JoinCondition> joinConditions = this.joinEnum.getJoinConditions();
        int i = 0;
        for (JoinCondition jc : joinConditions) {
            if (this.subset(jc.datasetBits, this.datasetBits)) {
                this.applicableJoinConditions.add(i);
            }
            ++i;
        }
    }

    protected List<Integer> getNewJoinConditionsOnly() {
        ArrayList<Integer> newJoinConditions = new ArrayList<Integer>();
        JoinNode leftJn = this.leftJn;
        JoinNode rightJn = this.rightJn;
        int newTableBits = 0;
        if (leftJn.jnArrayIndex <= this.joinEnum.numberOfTerms) {
            newTableBits = leftJn.datasetBits;
        } else if (rightJn.jnArrayIndex <= this.joinEnum.numberOfTerms) {
            newTableBits = rightJn.datasetBits;
        }
        if (LOGGER.isTraceEnabled() && newTableBits == 0) {
            LOGGER.trace("newTable Bits == 0");
        }
        for (int idx : this.applicableJoinConditions) {
            if ((this.joinEnum.joinConditions.get((int)idx).datasetBits & newTableBits) <= 0) continue;
            newJoinConditions.add(idx);
        }
        return newJoinConditions;
    }

    public int addSingleDatasetPlans() {
        boolean forceEnum;
        Cost opCost;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        Cost totalCost = opCost = this.joinEnum.getCostMethodsHandle().costFullScan(this);
        boolean bl = forceEnum = this.level <= this.joinEnum.cboFullEnumLevel;
        if (this.cheapestPlanIndex == PlanNode.NO_PLAN || opCost.costLT(this.cheapestPlanCost) || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum);
            pn.jn = this;
            pn.datasetName = this.datasetNames.get(0);
            pn.correspondingEmptyTupleSourceOp = this.correspondingEmptyTupleSourceOp;
            pn.jnIndexes[0] = this.jnArrayIndex;
            pn.jnIndexes[1] = NO_JN;
            pn.planIndexes[0] = PlanNode.NO_PLAN;
            pn.planIndexes[1] = PlanNode.NO_PLAN;
            pn.opCost = opCost;
            pn.scanOp = PlanNode.ScanMethod.TABLE_SCAN;
            pn.totalCost = totalCost;
            allPlans.add(pn);
            this.planIndexesArray.add(pn.allPlansIndex);
            PlanNode cheapestPlan = !forceEnum ? pn : this.findCheapestPlan();
            this.cheapestPlanCost = cheapestPlan.totalCost;
            this.cheapestPlanIndex = cheapestPlan.allPlansIndex;
            return pn.allPlansIndex;
        }
        return PlanNode.NO_PLAN;
    }

    protected void buildIndexPlan(boolean forceIndexPlan) {
        boolean forceEnum;
        Cost opCost;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        Cost totalCost = opCost = this.joinEnum.getCostMethodsHandle().costIndexScan(this);
        boolean bl = forceEnum = this.level <= this.joinEnum.cboFullEnumLevel;
        if (this.cheapestPlanIndex == PlanNode.NO_PLAN || opCost.costLT(this.cheapestPlanCost) || forceIndexPlan || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum);
            pn.jn = this;
            pn.datasetName = this.datasetNames.get(0);
            pn.correspondingEmptyTupleSourceOp = this.correspondingEmptyTupleSourceOp;
            pn.jnIndexes[0] = this.jnArrayIndex;
            pn.jnIndexes[1] = NO_JN;
            pn.planIndexes[0] = PlanNode.NO_PLAN;
            pn.planIndexes[1] = PlanNode.NO_PLAN;
            pn.opCost = opCost;
            pn.scanOp = PlanNode.ScanMethod.INDEX_SCAN;
            pn.indexHint = forceIndexPlan;
            pn.totalCost = totalCost;
            allPlans.add(pn);
            this.planIndexesArray.add(pn.allPlansIndex);
            PlanNode cheapestPlan = !forceEnum ? pn : this.findCheapestPlan();
            this.cheapestPlanCost = cheapestPlan.totalCost;
            this.cheapestPlanIndex = cheapestPlan.allPlansIndex;
        }
    }

    protected void costAndChooseIndexPlans(ILogicalOperator leafInput, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) throws AlgebricksException {
        for (Map.Entry<IAccessMethod, AccessMethodAnalysisContext> amEntry : analyzedAMs.entrySet()) {
            AccessMethodAnalysisContext analysisCtx = amEntry.getValue();
            Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexIt = analysisCtx.getIteratorForIndexExprsAndVars();
            List<IOptimizableFuncExpr> exprs = analysisCtx.getMatchedFuncExprs();
            while (indexIt.hasNext()) {
                Map.Entry<Index, List<Pair<Integer, Integer>>> indexEntry = indexIt.next();
                Index chosenIndex = indexEntry.getKey();
                int exprIndex = (Integer)indexEntry.getValue().get(0).getFirst();
                IOptimizableFuncExpr expr = exprs.get(exprIndex);
                AbstractFunctionCallExpression afce = expr.getFuncExpr();
                PredicateCardinalityAnnotation selectivityAnnotation = (PredicateCardinalityAnnotation)afce.getAnnotation(PredicateCardinalityAnnotation.class);
                if (this.joinEnum.findUseIndexHint(afce)) {
                    this.buildIndexPlan(true);
                    continue;
                }
                if (selectivityAnnotation == null) continue;
                double sel = selectivityAnnotation.getSelectivity();
                if (sel >= this.joinEnum.stats.SELECTIVITY_FOR_SECONDARY_INDEX_SELECTION) {
                    afce.putAnnotation((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.newInstance(Collections.singleton(chosenIndex.getIndexName())));
                    continue;
                }
                this.buildIndexPlan(false);
            }
        }
    }

    private SelectOperator copySelExprsAndSetTrue(List<ILogicalExpression> selExprs, List<SelectOperator> selOpers, ILogicalOperator leafInput) {
        ILogicalOperator op = leafInput;
        SelectOperator firstSelOp = null;
        boolean firstSel = true;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
                SelectOperator selOp = (SelectOperator)op;
                if (firstSel) {
                    firstSelOp = selOp;
                    firstSel = false;
                }
                selOpers.add(selOp);
                selExprs.add((ILogicalExpression)selOp.getCondition().getValue());
                selOp.getCondition().setValue((Object)ConstantExpression.TRUE);
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return firstSelOp;
    }

    private void restoreSelExprs(List<ILogicalExpression> selExprs, List<SelectOperator> selOpers) {
        for (int i = 0; i < selExprs.size(); ++i) {
            selOpers.get(i).getCondition().setValue((Object)selExprs.get(i));
        }
    }

    private ILogicalExpression andAlltheExprs(List<ILogicalExpression> selExprs) {
        if (selExprs.size() == 1) {
            return selExprs.get(0);
        }
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        for (ILogicalExpression se : selExprs) {
            andExpr.getArguments().add(new MutableObject((Object)se));
        }
        return andExpr;
    }

    private boolean combineDoubleSelectsBeforeSubPlans(ILogicalOperator op) {
        boolean changes = false;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            SelectOperator selOp2;
            ILogicalOperator op2;
            SelectOperator selOp1;
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT && ((ILogicalOperator)((Mutable)(selOp1 = (SelectOperator)op).getInputs().get(0)).getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.SELECT) && (op2 = (ILogicalOperator)((Mutable)(selOp2 = (SelectOperator)((Mutable)op.getInputs().get(0)).getValue()).getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                ((Mutable)selOp1.getInputs().get(0)).setValue((Object)op2);
                ILogicalExpression exp1 = (ILogicalExpression)selOp1.getCondition().getValue();
                ILogicalExpression exp2 = (ILogicalExpression)selOp2.getCondition().getValue();
                ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
                andExpr.getArguments().add(new MutableObject((Object)exp1));
                andExpr.getArguments().add(new MutableObject((Object)exp2));
                selOp1.getCondition().setValue((Object)andExpr);
                op = (ILogicalOperator)((Mutable)op2.getInputs().get(0)).getValue();
                changes = true;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return changes;
    }

    public void addIndexAccessPlans(ILogicalOperator leafInput) throws AlgebricksException {
        IntroduceSelectAccessMethodRule tmp = new IntroduceSelectAccessMethodRule();
        ArrayList<Pair<IAccessMethod, Index>> chosenIndexes = new ArrayList<Pair<IAccessMethod, Index>>();
        TreeMap<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs = new TreeMap<IAccessMethod, AccessMethodAnalysisContext>();
        while (this.combineDoubleSelectsBeforeSubPlans(leafInput)) {
        }
        ArrayList<ILogicalExpression> selExprs = new ArrayList<ILogicalExpression>();
        ArrayList<SelectOperator> selOpers = new ArrayList<SelectOperator>();
        SelectOperator firstSelop = this.copySelExprsAndSetTrue(selExprs, selOpers, leafInput);
        if (firstSelop != null) {
            firstSelop.getCondition().setValue((Object)this.andAlltheExprs(selExprs));
            boolean index_access_possible = tmp.checkApplicable((Mutable<ILogicalOperator>)new MutableObject((Object)leafInput), this.joinEnum.optCtx, chosenIndexes, analyzedAMs);
            this.chosenIndexes = chosenIndexes;
            this.analyzedAMs = analyzedAMs;
            this.restoreSelExprs(selExprs, selOpers);
            if (index_access_possible) {
                this.costAndChooseIndexPlans(leafInput, analyzedAMs);
            }
        } else {
            this.restoreSelExprs(selExprs, selOpers);
        }
    }

    protected int buildHashJoinPlan(JoinNode leftJn, JoinNode rightJn, PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, HashJoinExpressionAnnotation hintHashJoin) {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (hashJoinExpr == null || hashJoinExpr == ConstantExpression.TRUE) {
            return PlanNode.NO_PLAN;
        }
        if (this.joinEnum.queryPlanShape.equals("leftdeep") && !leftJn.IsBaseLevelJoinNode() && this.level > this.joinEnum.cboFullEnumLevel) {
            return PlanNode.NO_PLAN;
        }
        if (this.joinEnum.queryPlanShape.equals("rightdeep") && !rightJn.IsBaseLevelJoinNode() && this.level > this.joinEnum.cboFullEnumLevel) {
            return PlanNode.NO_PLAN;
        }
        boolean bl = forceEnum = hintHashJoin != null || this.joinEnum.forceJoinOrderMode || !this.joinEnum.queryPlanShape.equals("zigzag") || this.level <= this.joinEnum.cboFullEnumLevel;
        if (rightJn.cardinality * rightJn.size <= leftJn.cardinality * leftJn.size || forceEnum) {
            Cost hjCost = this.joinEnum.getCostMethodsHandle().costHashJoin(this);
            Cost leftExchangeCost = this.joinEnum.getCostMethodsHandle().computeHJProbeExchangeCost(this);
            Cost rightExchangeCost = this.joinEnum.getCostMethodsHandle().computeHJBuildExchangeCost(this);
            ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost.costAdd(allPlans.get((int)rightPlan.allPlansIndex).totalCost);
            ICost totalCost = hjCost.costAdd(leftExchangeCost).costAdd(rightExchangeCost).costAdd(childCosts);
            if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
                PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum);
                pn.jn = this;
                pn.jnIndexes[0] = leftJn.jnArrayIndex;
                pn.jnIndexes[1] = rightJn.jnArrayIndex;
                pn.planIndexes[0] = leftPlan.allPlansIndex;
                pn.planIndexes[1] = rightPlan.allPlansIndex;
                pn.joinOp = PlanNode.JoinMethod.HYBRID_HASH_JOIN;
                pn.joinHint = hintHashJoin;
                pn.side = HashJoinExpressionAnnotation.BuildSide.RIGHT;
                pn.joinExpr = hashJoinExpr;
                pn.opCost = hjCost;
                pn.totalCost = totalCost;
                pn.leftExchangeCost = leftExchangeCost;
                pn.rightExchangeCost = rightExchangeCost;
                allPlans.add(pn);
                this.planIndexesArray.add(pn.allPlansIndex);
                PlanNode cheapestPlan = !forceEnum ? pn : this.findCheapestPlan();
                this.cheapestPlanCost = cheapestPlan.totalCost;
                this.cheapestPlanIndex = cheapestPlan.allPlansIndex;
                return pn.allPlansIndex;
            }
        }
        return PlanNode.NO_PLAN;
    }

    protected int buildBroadcastHashJoinPlan(JoinNode leftJn, JoinNode rightJn, PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, BroadcastExpressionAnnotation hintBroadcastHashJoin) {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (hashJoinExpr == null || hashJoinExpr == ConstantExpression.TRUE) {
            return PlanNode.NO_PLAN;
        }
        if (this.joinEnum.queryPlanShape.equals("leftdeep") && !leftJn.IsBaseLevelJoinNode() && this.level > this.joinEnum.cboFullEnumLevel) {
            return PlanNode.NO_PLAN;
        }
        if (this.joinEnum.queryPlanShape.equals("rightdeep") && !rightJn.IsBaseLevelJoinNode() && this.level > this.joinEnum.cboFullEnumLevel) {
            return PlanNode.NO_PLAN;
        }
        boolean bl = forceEnum = hintBroadcastHashJoin != null || this.joinEnum.forceJoinOrderMode || !this.joinEnum.queryPlanShape.equals("zigzag") || this.level <= this.joinEnum.cboFullEnumLevel;
        if (rightJn.cardinality * rightJn.size <= leftJn.cardinality * leftJn.size || forceEnum) {
            Cost bcastHjCost = this.joinEnum.getCostMethodsHandle().costBroadcastHashJoin(this);
            ICost leftExchangeCost = this.joinEnum.getCostHandle().zeroCost();
            Cost rightExchangeCost = this.joinEnum.getCostMethodsHandle().computeBHJBuildExchangeCost(this);
            ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost.costAdd(allPlans.get((int)rightPlan.allPlansIndex).totalCost);
            ICost totalCost = bcastHjCost.costAdd(rightExchangeCost).costAdd(childCosts);
            if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
                PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum);
                pn.jn = this;
                pn.jnIndexes[0] = leftJn.jnArrayIndex;
                pn.jnIndexes[1] = rightJn.jnArrayIndex;
                pn.planIndexes[0] = leftPlan.allPlansIndex;
                pn.planIndexes[1] = rightPlan.allPlansIndex;
                pn.joinOp = PlanNode.JoinMethod.BROADCAST_HASH_JOIN;
                pn.joinHint = hintBroadcastHashJoin;
                pn.side = HashJoinExpressionAnnotation.BuildSide.RIGHT;
                pn.joinExpr = hashJoinExpr;
                pn.opCost = bcastHjCost;
                pn.totalCost = totalCost;
                pn.leftExchangeCost = leftExchangeCost;
                pn.rightExchangeCost = rightExchangeCost;
                allPlans.add(pn);
                this.planIndexesArray.add(pn.allPlansIndex);
                PlanNode cheapestPlan = !forceEnum ? pn : this.findCheapestPlan();
                this.cheapestPlanCost = cheapestPlan.totalCost;
                this.cheapestPlanIndex = cheapestPlan.allPlansIndex;
                return pn.allPlansIndex;
            }
        }
        return PlanNode.NO_PLAN;
    }

    protected int buildNLJoinPlan(JoinNode leftJn, JoinNode rightJn, PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression nestedLoopJoinExpr, IndexedNLJoinExpressionAnnotation hintNLJoin) throws AlgebricksException {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        int numberOfTerms = this.joinEnum.numberOfTerms;
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (rightJn.jnArrayIndex > numberOfTerms) {
            return PlanNode.NO_PLAN;
        }
        if (nestedLoopJoinExpr == null || !rightJn.nestedLoopsApplicable(nestedLoopJoinExpr)) {
            return PlanNode.NO_PLAN;
        }
        Cost nljCost = this.joinEnum.getCostMethodsHandle().costIndexNLJoin(this);
        Cost leftExchangeCost = this.joinEnum.getCostMethodsHandle().computeNLJOuterExchangeCost(this);
        ICost rightExchangeCost = this.joinEnum.getCostHandle().zeroCost();
        ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost;
        ICost totalCost = nljCost.costAdd(leftExchangeCost).costAdd(childCosts);
        boolean bl = forceEnum = hintNLJoin != null || this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel;
        if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum);
            pn.jn = this;
            pn.jnIndexes[0] = leftJn.jnArrayIndex;
            pn.jnIndexes[1] = rightJn.jnArrayIndex;
            pn.planIndexes[0] = leftPlan.allPlansIndex;
            pn.planIndexes[1] = rightPlan.allPlansIndex;
            pn.joinOp = PlanNode.JoinMethod.INDEX_NESTED_LOOP_JOIN;
            pn.joinHint = hintNLJoin;
            pn.joinExpr = nestedLoopJoinExpr;
            pn.opCost = nljCost;
            pn.totalCost = totalCost;
            pn.leftExchangeCost = leftExchangeCost;
            pn.rightExchangeCost = rightExchangeCost;
            allPlans.add(pn);
            this.planIndexesArray.add(pn.allPlansIndex);
            PlanNode cheapestPlan = !forceEnum ? pn : this.findCheapestPlan();
            this.cheapestPlanCost = cheapestPlan.totalCost;
            this.cheapestPlanIndex = cheapestPlan.allPlansIndex;
            return pn.allPlansIndex;
        }
        return PlanNode.NO_PLAN;
    }

    protected int buildCPJoinPlan(JoinNode leftJn, JoinNode rightJn, PlanNode leftPlan, PlanNode rightPlan, ILogicalExpression hashJoinExpr, ILogicalExpression nestedLoopJoinExpr) {
        boolean forceEnum;
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        if (!this.joinEnum.cboCPEnumMode) {
            return PlanNode.NO_PLAN;
        }
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        ILogicalExpression cpJoinExpr = null;
        List<Integer> newJoinConditions = this.getNewJoinConditionsOnly();
        if (hashJoinExpr == null && nestedLoopJoinExpr == null) {
            cpJoinExpr = this.joinEnum.combineAllConditions(newJoinConditions);
        } else if (hashJoinExpr != null && nestedLoopJoinExpr == null) {
            cpJoinExpr = hashJoinExpr;
        } else if (hashJoinExpr == null) {
            cpJoinExpr = nestedLoopJoinExpr;
        } else if (Objects.equals(hashJoinExpr, nestedLoopJoinExpr)) {
            cpJoinExpr = hashJoinExpr;
        } else {
            ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
            andExpr.getArguments().add(new MutableObject((Object)hashJoinExpr));
            andExpr.getArguments().add(new MutableObject((Object)nestedLoopJoinExpr));
            cpJoinExpr = andExpr;
        }
        Cost cpCost = this.joinEnum.getCostMethodsHandle().costCartesianProductJoin(this);
        ICost leftExchangeCost = this.joinEnum.getCostHandle().zeroCost();
        Cost rightExchangeCost = this.joinEnum.getCostMethodsHandle().computeCPRightExchangeCost(this);
        ICost childCosts = allPlans.get((int)leftPlan.allPlansIndex).totalCost.costAdd(allPlans.get((int)rightPlan.allPlansIndex).totalCost);
        ICost totalCost = cpCost.costAdd(rightExchangeCost).costAdd(childCosts);
        boolean bl = forceEnum = this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel;
        if (this.cheapestPlanIndex == PlanNode.NO_PLAN || totalCost.costLT(this.cheapestPlanCost) || forceEnum) {
            PlanNode pn = new PlanNode(allPlans.size(), this.joinEnum);
            pn.jn = this;
            pn.jnIndexes[0] = leftJn.jnArrayIndex;
            pn.jnIndexes[1] = rightJn.jnArrayIndex;
            pn.planIndexes[0] = leftPlan.allPlansIndex;
            pn.planIndexes[1] = rightPlan.allPlansIndex;
            pn.joinOp = PlanNode.JoinMethod.CARTESIAN_PRODUCT_JOIN;
            pn.joinExpr = (ILogicalExpression)Objects.requireNonNullElse(cpJoinExpr, ConstantExpression.TRUE);
            pn.opCost = cpCost;
            pn.totalCost = totalCost;
            pn.leftExchangeCost = leftExchangeCost;
            pn.rightExchangeCost = rightExchangeCost;
            allPlans.add(pn);
            this.planIndexesArray.add(pn.allPlansIndex);
            PlanNode cheapestPlan = !forceEnum ? pn : this.findCheapestPlan();
            this.cheapestPlanCost = cheapestPlan.totalCost;
            this.cheapestPlanIndex = cheapestPlan.allPlansIndex;
            return pn.allPlansIndex;
        }
        return PlanNode.NO_PLAN;
    }

    protected void addMultiDatasetPlans(JoinNode leftJn, JoinNode rightJn) throws AlgebricksException {
        if (this.level > this.joinEnum.cboFullEnumLevel) {
            if (leftJn.cheapestPlanIndex == PlanNode.NO_PLAN || rightJn.cheapestPlanIndex == PlanNode.NO_PLAN) {
                return;
            }
            PlanNode leftPlan = this.joinEnum.allPlans.get(leftJn.cheapestPlanIndex);
            PlanNode rightPlan = this.joinEnum.allPlans.get(rightJn.cheapestPlanIndex);
            this.addMultiDatasetPlans(leftJn, rightJn, leftPlan, rightPlan);
        } else {
            for (int leftPlanIndex : leftJn.planIndexesArray) {
                PlanNode leftPlan = this.joinEnum.allPlans.get(leftPlanIndex);
                for (int rightPlanIndex : rightJn.planIndexesArray) {
                    PlanNode rightPlan = this.joinEnum.allPlans.get(rightPlanIndex);
                    this.addMultiDatasetPlans(leftJn, rightJn, leftPlan, rightPlan);
                }
            }
        }
    }

    protected void addMultiDatasetPlans(JoinNode leftJn, JoinNode rightJn, PlanNode leftPlan, PlanNode rightPlan) throws AlgebricksException {
        int commutativeCpPlan;
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        ICost noJoinCost = this.joinEnum.getCostHandle().maxCost();
        if (leftJn.planIndexesArray.size() == 0 || rightJn.planIndexesArray.size() == 0) {
            return;
        }
        if (this.cardinality >= 1.0E200) {
            return;
        }
        if (leftJn.cheapestPlanIndex == PlanNode.NO_PLAN || rightJn.cheapestPlanIndex == PlanNode.NO_PLAN) {
            return;
        }
        List<Integer> newJoinConditions = this.getNewJoinConditionsOnly();
        if (newJoinConditions.size() == 0 && this.joinEnum.connectedJoinGraph && leftJn.cardinality * rightJn.cardinality > 10000.0 && this.level > this.joinEnum.cboFullEnumLevel) {
            return;
        }
        ILogicalExpression hashJoinExpr = this.joinEnum.getHashJoinExpr(newJoinConditions);
        ILogicalExpression nestedLoopJoinExpr = this.joinEnum.getNestedLoopJoinExpr(newJoinConditions);
        double current_card = this.cardinality;
        if (current_card >= 1.0E200) {
            return;
        }
        int cpPlan = commutativeCpPlan = PlanNode.NO_PLAN;
        int commutativeNljPlan = commutativeCpPlan;
        int nljPlan = commutativeCpPlan;
        int commutativeBcastHjPlan = commutativeCpPlan;
        int bcastHjPlan = commutativeCpPlan;
        int commutativeHjPlan = commutativeCpPlan;
        int hjPlan = commutativeCpPlan;
        HashJoinExpressionAnnotation hintHashJoin = this.joinEnum.findHashJoinHint(newJoinConditions);
        BroadcastExpressionAnnotation hintBroadcastHashJoin = this.joinEnum.findBroadcastHashJoinHint(newJoinConditions);
        IndexedNLJoinExpressionAnnotation hintNLJoin = this.joinEnum.findNLJoinHint(newJoinConditions);
        if (hintHashJoin != null) {
            boolean build = hintHashJoin.getBuildOrProbe() == HashJoinExpressionAnnotation.BuildOrProbe.BUILD;
            boolean probe = hintHashJoin.getBuildOrProbe() == HashJoinExpressionAnnotation.BuildOrProbe.PROBE;
            boolean validBuildOrProbeObject = false;
            String buildOrProbeObject = hintHashJoin.getName();
            if (buildOrProbeObject != null && (rightJn.datasetNames.contains(buildOrProbeObject) || rightJn.aliases.contains(buildOrProbeObject) || leftJn.datasetNames.contains(buildOrProbeObject) || leftJn.aliases.contains(buildOrProbeObject))) {
                validBuildOrProbeObject = true;
            }
            if (validBuildOrProbeObject) {
                if (build && (rightJn.datasetNames.contains(buildOrProbeObject) || rightJn.aliases.contains(buildOrProbeObject)) || probe && (leftJn.datasetNames.contains(buildOrProbeObject) || leftJn.aliases.contains(buildOrProbeObject))) {
                    hjPlan = this.buildHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, hintHashJoin);
                } else if (build && (leftJn.datasetNames.contains(buildOrProbeObject) || leftJn.aliases.contains(buildOrProbeObject)) || probe && (rightJn.datasetNames.contains(buildOrProbeObject) || rightJn.aliases.contains(buildOrProbeObject))) {
                    commutativeHjPlan = this.buildHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, hintHashJoin);
                }
            } else {
                IWarningCollector warningCollector;
                if (!this.joinEnum.getJoinConditions().isEmpty() && !newJoinConditions.isEmpty() && (warningCollector = this.joinEnum.optCtx.getWarningCollector()).shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)this.joinEnum.getJoinConditions().get((int)newJoinConditions.get((int)0).intValue()).joinCondition.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"hash join", (build ? "build " : "probe ") + "with " + buildOrProbeObject}));
                }
                hjPlan = this.buildHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeHjPlan = this.buildHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
                }
                bcastHjPlan = this.buildBroadcastHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
                }
                nljPlan = this.buildNLJoinPlan(leftJn, rightJn, leftPlan, rightPlan, nestedLoopJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeNljPlan = this.buildNLJoinPlan(rightJn, leftJn, rightPlan, leftPlan, nestedLoopJoinExpr, null);
                }
                cpPlan = this.buildCPJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, nestedLoopJoinExpr);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeCpPlan = this.buildCPJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, nestedLoopJoinExpr);
                }
            }
        } else if (hintBroadcastHashJoin != null) {
            boolean validBroadcastObject = false;
            String broadcastObject = hintBroadcastHashJoin.getName();
            if (broadcastObject != null && (rightJn.datasetNames.contains(broadcastObject) || rightJn.aliases.contains(broadcastObject) || leftJn.datasetNames.contains(broadcastObject) || leftJn.aliases.contains(broadcastObject))) {
                validBroadcastObject = true;
            }
            if (validBroadcastObject) {
                if (rightJn.datasetNames.contains(broadcastObject) || rightJn.aliases.contains(broadcastObject)) {
                    bcastHjPlan = this.buildBroadcastHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, hintBroadcastHashJoin);
                } else if (leftJn.datasetNames.contains(broadcastObject) || leftJn.aliases.contains(broadcastObject)) {
                    commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, hintBroadcastHashJoin);
                }
            } else if (broadcastObject == null) {
                bcastHjPlan = this.buildBroadcastHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, hintBroadcastHashJoin);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, hintBroadcastHashJoin);
                }
            } else {
                IWarningCollector warningCollector;
                if (!this.joinEnum.getJoinConditions().isEmpty() && !newJoinConditions.isEmpty() && (warningCollector = this.joinEnum.optCtx.getWarningCollector()).shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)this.joinEnum.getJoinConditions().get((int)newJoinConditions.get((int)0).intValue()).joinCondition.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"broadcast hash join", "broadcast " + broadcastObject}));
                }
                hjPlan = this.buildHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeHjPlan = this.buildHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
                }
                bcastHjPlan = this.buildBroadcastHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
                }
                nljPlan = this.buildNLJoinPlan(leftJn, rightJn, leftPlan, rightPlan, nestedLoopJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeNljPlan = this.buildNLJoinPlan(rightJn, leftJn, rightPlan, leftPlan, nestedLoopJoinExpr, null);
                }
                cpPlan = this.buildCPJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, nestedLoopJoinExpr);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeCpPlan = this.buildCPJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, nestedLoopJoinExpr);
                }
            }
        } else if (hintNLJoin != null) {
            nljPlan = this.buildNLJoinPlan(leftJn, rightJn, leftPlan, rightPlan, nestedLoopJoinExpr, hintNLJoin);
            if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                commutativeNljPlan = this.buildNLJoinPlan(rightJn, leftJn, rightPlan, leftPlan, nestedLoopJoinExpr, hintNLJoin);
            }
            if (nljPlan == PlanNode.NO_PLAN && commutativeNljPlan == PlanNode.NO_PLAN) {
                IWarningCollector warningCollector;
                if (!this.joinEnum.getJoinConditions().isEmpty() && !newJoinConditions.isEmpty() && (warningCollector = this.joinEnum.optCtx.getWarningCollector()).shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)this.joinEnum.getJoinConditions().get((int)newJoinConditions.get((int)0).intValue()).joinCondition.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"index nested loop join", "ignored"}));
                }
                hjPlan = this.buildHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeHjPlan = this.buildHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
                }
                bcastHjPlan = this.buildBroadcastHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
                }
                cpPlan = this.buildCPJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, nestedLoopJoinExpr);
                if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                    commutativeCpPlan = this.buildCPJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, nestedLoopJoinExpr);
                }
            }
        } else {
            hjPlan = this.buildHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
            if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                commutativeHjPlan = this.buildHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
            }
            bcastHjPlan = this.buildBroadcastHashJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, null);
            if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                commutativeBcastHjPlan = this.buildBroadcastHashJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, null);
            }
            nljPlan = this.buildNLJoinPlan(leftJn, rightJn, leftPlan, rightPlan, nestedLoopJoinExpr, null);
            if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                commutativeNljPlan = this.buildNLJoinPlan(rightJn, leftJn, rightPlan, leftPlan, nestedLoopJoinExpr, null);
            }
            cpPlan = this.buildCPJoinPlan(leftJn, rightJn, leftPlan, rightPlan, hashJoinExpr, nestedLoopJoinExpr);
            if (!this.joinEnum.forceJoinOrderMode || this.level <= this.joinEnum.cboFullEnumLevel) {
                commutativeCpPlan = this.buildCPJoinPlan(rightJn, leftJn, rightPlan, leftPlan, hashJoinExpr, nestedLoopJoinExpr);
            }
        }
        this.leftJn = leftJn;
        this.rightJn = rightJn;
        if (hjPlan == PlanNode.NO_PLAN && commutativeHjPlan == PlanNode.NO_PLAN && bcastHjPlan == PlanNode.NO_PLAN && commutativeBcastHjPlan == PlanNode.NO_PLAN && nljPlan == PlanNode.NO_PLAN && commutativeNljPlan == PlanNode.NO_PLAN && cpPlan == PlanNode.NO_PLAN && commutativeCpPlan == PlanNode.NO_PLAN) {
            return;
        }
    }

    private PlanNode findCheapestPlan() {
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        ICost cheapestCost = this.joinEnum.getCostHandle().maxCost();
        PlanNode cheapestPlanNode = null;
        boolean isCheapestPlanHinted = false;
        for (int planIndex : this.planIndexesArray) {
            boolean isPlanHinted;
            PlanNode plan = allPlans.get(planIndex);
            boolean bl = isPlanHinted = plan.joinHint != null || plan.indexHint;
            if (isPlanHinted && !isCheapestPlanHinted) {
                cheapestPlanNode = plan;
                cheapestCost = plan.totalCost;
                isCheapestPlanHinted = true;
                continue;
            }
            if (!isPlanHinted && isCheapestPlanHinted || !plan.totalCost.costLT(cheapestCost)) continue;
            cheapestPlanNode = plan;
            cheapestCost = plan.totalCost;
            isCheapestPlanHinted = isPlanHinted;
        }
        return cheapestPlanNode;
    }

    public String toString() {
        int j;
        if (this.planIndexesArray.isEmpty()) {
            return "";
        }
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        StringBuilder sb = new StringBuilder(128);
        sb.append("Printing Join Node ").append(this.jnArrayIndex).append('\n');
        sb.append("datasetNames ").append('\n');
        for (String datasetName : this.datasetNames) {
            sb.append(datasetName).append(' ');
        }
        sb.append("datasetIndex ").append('\n');
        for (j = 0; j < this.datasetIndexes.size(); ++j) {
            sb.append(j).append(this.datasetIndexes.get(j)).append('\n');
        }
        sb.append("datasetBits is ").append(this.datasetBits).append('\n');
        if (this.IsBaseLevelJoinNode()) {
            sb.append("orig cardinality is ").append((double)Math.round(this.origCardinality * 100.0) / 100.0).append('\n');
        }
        sb.append("cardinality is ").append((double)Math.round(this.cardinality * 100.0) / 100.0).append('\n');
        if (this.planIndexesArray.size() == 0) {
            sb.append("No plans considered for this join node").append('\n');
        }
        for (j = 0; j < this.planIndexesArray.size(); ++j) {
            int k = this.planIndexesArray.get(j);
            PlanNode pn = allPlans.get(k);
            sb.append("planIndexesArray  [").append(j).append("] is ").append(k).append('\n');
            sb.append("Printing PlanNode ").append(k).append('\n');
            if (this.IsBaseLevelJoinNode()) {
                sb.append("DATA_SOURCE_SCAN").append('\n');
            } else {
                sb.append("\n");
                sb.append((String)pn.joinMethod().getFirst()).append('\n');
                sb.append("Printing Join expr ").append('\n');
                if (pn.joinExpr != null) {
                    sb.append(pn.joinExpr).append('\n');
                } else {
                    sb.append("null").append('\n');
                }
            }
            sb.append("card ").append((double)Math.round(this.cardinality * 100.0) / 100.0).append('\n');
            sb.append("------------------").append('\n');
            sb.append("operator cost ").append(pn.opCost.computeTotalCost()).append('\n');
            sb.append("total cost ").append(pn.totalCost.computeTotalCost()).append('\n');
            sb.append("jnIndexes ").append(pn.jnIndexes[0]).append(" ").append(pn.jnIndexes[1]).append('\n');
            if (this.IsHigherLevelJoinNode()) {
                PlanNode leftPlan = pn.getLeftPlanNode();
                PlanNode rightPlan = pn.getRightPlanNode();
                int l = leftPlan.allPlansIndex;
                int r = rightPlan.allPlansIndex;
                sb.append("planIndexes ").append(l).append(" ").append(r).append('\n');
                sb.append("(lcost = ").append(leftPlan.totalCost.computeTotalCost()).append(") (rcost = ").append(rightPlan.totalCost.computeTotalCost()).append(")").append('\n');
            }
            sb.append("\n");
        }
        sb.append("jnIndex ").append(this.jnIndex).append('\n');
        sb.append("datasetBits ").append(this.datasetBits).append('\n');
        sb.append("cardinality ").append((double)Math.round(this.cardinality * 100.0) / 100.0).append('\n');
        sb.append("size ").append((double)Math.round(this.size * 100.0) / 100.0).append('\n');
        sb.append("level ").append(this.level).append('\n');
        sb.append("highestDatasetId ").append(this.highestDatasetId).append('\n');
        sb.append("--------------------------------------").append('\n');
        return sb.toString();
    }

    public void printCostOfAllPlans(StringBuilder sb) {
        List<PlanNode> allPlans = this.joinEnum.allPlans;
        ICost minCost = this.joinEnum.getCostHandle().maxCost();
        for (int planIndex : this.planIndexesArray) {
            ICost planCost = allPlans.get((int)planIndex).totalCost;
            sb.append("plan ").append(planIndex).append(" cost is ").append(planCost.computeTotalCost()).append('\n');
            if (!planCost.costLT(minCost)) continue;
            minCost = planCost;
        }
        sb.append("LOWEST COST ").append(minCost.computeTotalCost()).append('\n');
    }
}

