/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.api.IBTreeInteriorFrame;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.api.ITupleAcceptor;
import org.apache.hyracks.storage.am.btree.impls.BTreeCursorInitialState;
import org.apache.hyracks.storage.am.btree.impls.BTreeSplitKey;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.arraylist.IntArrayList;
import org.apache.hyracks.storage.common.arraylist.LongArrayList;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;

public class BTreeOpContext
implements IIndexOperationContext,
IExtraPageBlockHelper {
    private static final int INIT_ARRAYLIST_SIZE = 6;
    private final IIndexAccessor accessor;
    private final MultiComparator cmp;
    private final ITreeIndexFrameFactory interiorFrameFactory;
    private final IBTreeInteriorFrame interiorFrame;
    private final IPageManager freePageManager;
    private final ITreeIndexMetadataFrame metaFrame;
    private ITreeIndexFrameFactory leafFrameFactory;
    private IBTreeLeafFrame leafFrame;
    private IndexOperation op;
    private ITreeIndexCursor cursor;
    private BTreeCursorInitialState cursorInitialState;
    private RangePredicate pred;
    private BTreeSplitKey splitKey;
    private LongArrayList pageLsns;
    private IntArrayList smPages;
    private IntArrayList freePages;
    private int opRestarts = 0;
    private boolean exceptionHandled;
    private IModificationOperationCallback modificationCallback;
    private ISearchOperationCallback searchCallback;
    private ITupleAcceptor acceptor;
    private int smoCount;
    private boolean destroyed = false;
    private final Deque<PageValidationInfo> validationInfos;
    private final ITreeIndexTupleReference interiorFrameTuple;

    public BTreeOpContext(IIndexAccessor accessor, ITreeIndexFrameFactory leafFrameFactory, ITreeIndexFrameFactory interiorFrameFactory, IPageManager freePageManager, IBinaryComparatorFactory[] cmpFactories, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        this.accessor = accessor;
        this.cmp = cmpFactories[0] != null ? MultiComparator.create((IBinaryComparatorFactory[])cmpFactories) : null;
        this.setLeafFrameFactory(leafFrameFactory);
        this.leafFrame = (IBTreeLeafFrame)leafFrameFactory.createFrame();
        if (this.getLeafFrame() != null && this.getCmp() != null) {
            this.getLeafFrame().setMultiComparator(this.getCmp());
        }
        this.interiorFrameFactory = interiorFrameFactory;
        this.interiorFrame = (IBTreeInteriorFrame)interiorFrameFactory.createFrame();
        if (this.getInteriorFrame() != null && this.getCmp() != null) {
            this.getInteriorFrame().setMultiComparator(this.getCmp());
        }
        this.freePageManager = freePageManager;
        this.metaFrame = freePageManager.createMetadataFrame();
        this.pageLsns = new LongArrayList(6, 6);
        this.smoCount = 0;
        this.modificationCallback = modificationCallback;
        this.searchCallback = searchCallback;
        this.validationInfos = new ArrayDeque<PageValidationInfo>(6);
        this.interiorFrameTuple = this.getInteriorFrame().createTupleReference();
    }

    public void reset() {
        if (this.pageLsns != null) {
            this.pageLsns.clear();
        }
        if (this.freePages != null) {
            this.freePages.clear();
        }
        if (this.smPages != null) {
            this.smPages.clear();
        }
        this.opRestarts = 0;
        this.smoCount = 0;
        this.exceptionHandled = false;
    }

    public void setOperation(IndexOperation newOp) {
        if (newOp == IndexOperation.SEARCH || newOp == IndexOperation.DISKORDERSCAN) {
            if (this.cursorInitialState == null) {
                this.cursorInitialState = new BTreeCursorInitialState(this.searchCallback, this.accessor);
            }
        } else {
            if (this.smPages == null) {
                this.smPages = new IntArrayList(6, 6);
            }
            if (this.freePages == null) {
                this.freePages = new IntArrayList(6, 6);
            }
            if (this.getPred() == null) {
                this.setPred(new RangePredicate(null, null, true, true, null, null));
            }
            if (this.splitKey == null) {
                this.splitKey = new BTreeSplitKey(this.getLeafFrame().getTupleWriter().createTupleReference());
            }
        }
        this.op = newOp;
        this.smoCount = 0;
        this.exceptionHandled = false;
    }

    public IBTreeLeafFrame createLeafFrame() {
        return (IBTreeLeafFrame)this.getLeafFrameFactory().createFrame();
    }

    public IBTreeInteriorFrame createInteriorFrame() {
        return (IBTreeInteriorFrame)this.interiorFrameFactory.createFrame();
    }

    public PageValidationInfo createPageValidationInfo(PageValidationInfo parent) throws HyracksDataException {
        return new PageValidationInfo(parent);
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public void setCallbacks(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        this.modificationCallback = modificationCallback;
        this.searchCallback = searchCallback;
        if (this.cursorInitialState != null) {
            this.cursorInitialState.setSearchOperationCallback(searchCallback);
        }
    }

    public int getFreeBlock(int size) throws HyracksDataException {
        return this.freePageManager.takeBlock(this.getMetaFrame(), size);
    }

    public void returnFreePageBlock(int blockPageId, int size) throws HyracksDataException {
        this.freePageManager.releaseBlock(this.getMetaFrame(), blockPageId, size);
    }

    public ITreeIndexMetadataFrame getMetaFrame() {
        return this.metaFrame;
    }

    public ISearchOperationCallback getSearchCallback() {
        return this.searchCallback;
    }

    public Deque<PageValidationInfo> getValidationInfos() {
        return this.validationInfos;
    }

    public IBTreeLeafFrame getLeafFrame() {
        return this.leafFrame;
    }

    public ITreeIndexTupleReference getInteriorFrameTuple() {
        return this.interiorFrameTuple;
    }

    public RangePredicate getPred() {
        return this.pred;
    }

    public void setPred(RangePredicate pred) {
        this.pred = pred;
    }

    public ITreeIndexCursor getCursor() {
        return this.cursor;
    }

    public void setCursor(ITreeIndexCursor cursor) {
        this.cursor = cursor;
    }

    public int getOpRestarts() {
        return this.opRestarts;
    }

    public LongArrayList getPageLsns() {
        return this.pageLsns;
    }

    public void setPageLsns(LongArrayList pageLsns) {
        this.pageLsns = pageLsns;
    }

    public IntArrayList getSmPages() {
        return this.smPages;
    }

    public IBTreeInteriorFrame getInteriorFrame() {
        return this.interiorFrame;
    }

    public int getSmoCount() {
        return this.smoCount;
    }

    public BTreeSplitKey getSplitKey() {
        return this.splitKey;
    }

    public IModificationOperationCallback getModificationCallback() {
        return this.modificationCallback;
    }

    public MultiComparator getCmp() {
        return this.cmp;
    }

    public ITupleAcceptor getAcceptor() {
        return this.acceptor;
    }

    public void setOpRestarts(int opRestarts) {
        this.opRestarts = opRestarts;
    }

    public BTreeCursorInitialState getCursorInitialState() {
        return this.cursorInitialState;
    }

    public boolean isExceptionHandled() {
        return this.exceptionHandled;
    }

    public void setExceptionHandled(boolean exceptionHandled) {
        this.exceptionHandled = exceptionHandled;
    }

    public void setAcceptor(ITupleAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void setSmoCount(int smoCount) {
        this.smoCount = smoCount;
    }

    public void setLeafFrame(IBTreeLeafFrame leafFrame) {
        this.leafFrame = leafFrame;
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.leafFrameFactory;
    }

    public void setLeafFrameFactory(ITreeIndexFrameFactory leafFrameFactory) {
        this.leafFrameFactory = leafFrameFactory;
    }

    public void destroy() throws HyracksDataException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])new IDestroyable[]{this.accessor, this.cursor});
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    public class PageValidationInfo {
        public final int numKeyFields;
        public final ArrayTupleBuilder lowRangeBuilder;
        public final ArrayTupleBuilder highRangeBuilder;
        public final ArrayTupleReference lowRangeTuple;
        public final ArrayTupleReference highRangeTuple;
        public boolean isLowRangeNull;
        public boolean isHighRangeNull;

        public PageValidationInfo() {
            this.numKeyFields = BTreeOpContext.this.getCmp().getKeyFieldCount();
            this.lowRangeBuilder = new ArrayTupleBuilder(this.numKeyFields);
            this.highRangeBuilder = new ArrayTupleBuilder(this.numKeyFields);
            this.lowRangeTuple = new ArrayTupleReference();
            this.highRangeTuple = new ArrayTupleReference();
            this.isLowRangeNull = true;
            this.isHighRangeNull = true;
        }

        public PageValidationInfo(PageValidationInfo copy) throws HyracksDataException {
            this();
            if (copy != null) {
                this.propagateLowRangeKey(copy);
                this.propagateHighRangeKey(copy);
            }
        }

        public void propagateLowRangeKey(PageValidationInfo toPropagate) throws HyracksDataException {
            this.isLowRangeNull = toPropagate.isLowRangeNull;
            if (!this.isLowRangeNull) {
                this.adjustRangeKey(this.lowRangeBuilder, this.lowRangeTuple, (ITupleReference)toPropagate.lowRangeTuple);
            }
        }

        public void propagateHighRangeKey(PageValidationInfo toPropagate) throws HyracksDataException {
            this.isHighRangeNull = toPropagate.isHighRangeNull;
            if (!this.isHighRangeNull) {
                this.adjustRangeKey(this.highRangeBuilder, this.highRangeTuple, (ITupleReference)toPropagate.highRangeTuple);
            }
        }

        public void adjustLowRangeKey(ITupleReference newLowRangeKey) throws HyracksDataException {
            boolean bl = this.isLowRangeNull = newLowRangeKey == null;
            if (!this.isLowRangeNull) {
                this.adjustRangeKey(this.lowRangeBuilder, this.lowRangeTuple, newLowRangeKey);
            }
        }

        public void adjustHighRangeKey(ITupleReference newHighRangeKey) throws HyracksDataException {
            boolean bl = this.isHighRangeNull = newHighRangeKey == null;
            if (!this.isHighRangeNull) {
                this.adjustRangeKey(this.highRangeBuilder, this.highRangeTuple, newHighRangeKey);
            }
        }

        private void adjustRangeKey(ArrayTupleBuilder builder, ArrayTupleReference tuple, ITupleReference newRangeKey) throws HyracksDataException {
            TupleUtils.copyTuple((ArrayTupleBuilder)builder, (ITupleReference)newRangeKey, (int)this.numKeyFields);
            tuple.reset(builder.getFieldEndOffsets(), builder.getByteArray());
        }
    }
}

