/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class Warning
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String component;
    private final SourceLocation srcLocation;
    private final int code;
    private final String message;
    private final Serializable[] params;

    private Warning(String component, SourceLocation srcLocation, int code, String message, Serializable ... params) {
        this.component = component;
        this.srcLocation = srcLocation;
        this.code = code;
        this.message = message;
        this.params = params;
    }

    public static Warning of(SourceLocation srcLocation, IError code, Serializable ... params) {
        return new Warning(code.component(), srcLocation, code.intValue(), ErrorMessageUtil.formatMessage(code.component(), code.intValue(), code.errorMessage(), srcLocation, params), params);
    }

    public String getComponent() {
        return this.component;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public SourceLocation getSourceLocation() {
        return this.srcLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        return Objects.equals(this.message, warning.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.component);
        output.writeInt(this.code);
        output.writeUTF(this.message);
        SourceLocation.writeFields(this.srcLocation, output);
        Warning.writeParams(output, this.params);
    }

    private static void writeParams(DataOutput output, Serializable[] params) throws IOException {
        byte[] serialize = SerializationUtils.serialize((Serializable)params);
        output.writeInt(serialize.length);
        output.write(serialize);
    }

    public static Warning create(DataInput input) throws IOException {
        String comp = input.readUTF();
        int code = input.readInt();
        String msg = input.readUTF();
        SourceLocation sourceLocation = SourceLocation.create(input);
        int paramsLen = input.readInt();
        byte[] paramsBytes = new byte[paramsLen];
        input.readFully(paramsBytes, 0, paramsBytes.length);
        Serializable[] params = (Serializable[])SerializationUtils.deserialize((byte[])paramsBytes);
        return new Warning(comp, sourceLocation, code, msg, params);
    }

    public String toString() {
        return "Warning{component='" + this.component + "', srcLocation=" + this.srcLocation + ", code=" + this.code + ", message='" + this.message + "'}";
    }

    public Serializable[] getParams() {
        return this.params;
    }
}

