/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.impl.DirectoryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectoryPolicyImpl
implements DirectoryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryPolicyImpl.class);
    public static final String UNKNOWN_MARKER_POLICY = "Unknown policy in fs.s3a.directory.marker.retention: ";
    private static final Set<DirectoryPolicy.MarkerPolicy> AVAILABLE_POLICIES = EnumSet.allOf(DirectoryPolicy.MarkerPolicy.class);
    public static final DirectoryPolicy KEEP = new DirectoryPolicyImpl(DirectoryPolicy.MarkerPolicy.Keep, p -> false);
    public static final DirectoryPolicy DELETE = new DirectoryPolicyImpl(DirectoryPolicy.MarkerPolicy.Delete, p -> false);
    private final DirectoryPolicy.MarkerPolicy markerPolicy;
    private final Predicate<Path> authoritativeness;

    public DirectoryPolicyImpl(DirectoryPolicy.MarkerPolicy markerPolicy, Predicate<Path> authoritativeness) {
        this.markerPolicy = markerPolicy;
        this.authoritativeness = authoritativeness;
    }

    @Override
    public boolean keepDirectoryMarkers(Path path) {
        switch (this.markerPolicy) {
            case Keep: {
                return true;
            }
            case Authoritative: {
                return this.authoritativeness.test(path);
            }
        }
        return false;
    }

    @Override
    public DirectoryPolicy.MarkerPolicy getMarkerPolicy() {
        return this.markerPolicy;
    }

    @Override
    public String describe() {
        return this.markerPolicy.getOptionName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DirectoryMarkerRetention{");
        sb.append("policy='").append(this.markerPolicy.getOptionName()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean hasPathCapability(Path path, String capability) {
        switch (capability) {
            case "fs.s3a.capability.directory.marker.aware": {
                return true;
            }
            case "fs.s3a.capability.directory.marker.policy.keep": {
                return this.markerPolicy == DirectoryPolicy.MarkerPolicy.Keep;
            }
            case "fs.s3a.capability.directory.marker.policy.delete": {
                return this.markerPolicy == DirectoryPolicy.MarkerPolicy.Delete;
            }
            case "fs.s3a.capability.directory.marker.policy.authoritative": {
                return this.markerPolicy == DirectoryPolicy.MarkerPolicy.Authoritative;
            }
            case "fs.s3a.capability.directory.marker.action.keep": {
                return this.keepDirectoryMarkers(path);
            }
            case "fs.s3a.capability.directory.marker.action.delete": {
                return !this.keepDirectoryMarkers(path);
            }
        }
        throw new IllegalArgumentException("Unknown capability " + capability);
    }

    public static DirectoryPolicy getDirectoryPolicy(Configuration conf, Predicate<Path> authoritativeness) {
        DirectoryPolicy policy;
        String option = conf.getTrimmed("fs.s3a.directory.marker.retention", "delete");
        switch (option.toLowerCase(Locale.ENGLISH)) {
            case "delete": {
                LOG.debug("Directory markers will be deleted");
                policy = DELETE;
                break;
            }
            case "keep": {
                LOG.info("Directory markers will be kept");
                policy = KEEP;
                break;
            }
            case "authoritative": {
                LOG.info("Directory markers will be kept on authoritative paths");
                policy = new DirectoryPolicyImpl(DirectoryPolicy.MarkerPolicy.Authoritative, authoritativeness);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNKNOWN_MARKER_POLICY + option);
            }
        }
        return policy;
    }

    public static Set<DirectoryPolicy.MarkerPolicy> availablePolicies() {
        return AVAILABLE_POLICIES;
    }
}

