/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AGeometrySerializerDeserializer;
import org.apache.asterix.geo.evaluators.functions.AbstractGetValDescriptor;
import org.apache.asterix.om.base.AGeometry;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class STMakePoint3DDescriptor
extends AbstractGetValDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = STMakePoint3DDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new STMakePoint3DEvaluator(args, ctx);
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_MAKE_POINT3D;
    }

    private class STMakePoint3DEvaluator
    implements IScalarEvaluator {
        private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private final DataOutput out = this.resultStorage.getDataOutput();
        private IPointable inputArg0 = new VoidPointable();
        private IPointable inputArg1 = new VoidPointable();
        private IPointable inputArg2 = new VoidPointable();
        private final IScalarEvaluator eval0;
        private final IScalarEvaluator eval1;
        private final IScalarEvaluator eval2;
        private Point point;
        private AGeometry pointGeometry;

        public STMakePoint3DEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval0 = args[0].createScalarEvaluator(ctx);
            this.eval1 = args[1].createScalarEvaluator(ctx);
            this.eval2 = args[2].createScalarEvaluator(ctx);
            this.point = new Point(0.0, 0.0, 0.0);
            this.pointGeometry = new AGeometry((OGCGeometry)new OGCPoint(this.point, SpatialReference.create((int)4326)));
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.eval0.evaluate(tuple, this.inputArg0);
            this.eval1.evaluate(tuple, this.inputArg1);
            this.eval2.evaluate(tuple, this.inputArg2);
            byte[] bytes0 = this.inputArg0.getByteArray();
            int offset0 = this.inputArg0.getStartOffset();
            byte[] bytes1 = this.inputArg1.getByteArray();
            int offset1 = this.inputArg1.getStartOffset();
            byte[] bytes2 = this.inputArg2.getByteArray();
            int offset2 = this.inputArg2.getStartOffset();
            this.resultStorage.reset();
            try {
                this.out.writeByte(ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
                this.point.setX(STMakePoint3DDescriptor.this.getVal(bytes0, offset0));
                this.point.setY(STMakePoint3DDescriptor.this.getVal(bytes1, offset1));
                this.point.setZ(STMakePoint3DDescriptor.this.getVal(bytes2, offset2));
                AGeometrySerializerDeserializer.INSTANCE.serialize(this.pointGeometry, this.out);
            }
            catch (IOException e1) {
                throw HyracksDataException.create((Throwable)e1);
            }
            result.set((IValueReference)this.resultStorage);
        }
    }
}

