/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.functions.ExternalScalarFunctionInfo;
import org.apache.asterix.metadata.functions.ExternalTypeComputer;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExternalFunctionCompilerUtil {
    private ExternalFunctionCompilerUtil() {
    }

    public static IFunctionInfo getExternalFunctionInfo(MetadataProvider metadataProvider, Function function) throws AlgebricksException {
        String functionKind = function.getKind();
        IFunctionInfo finfo = null;
        if (AbstractFunctionCallExpression.FunctionKind.SCALAR.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getScalarFunctionInfo(metadataProvider, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.AGGREGATE.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getAggregateFunctionInfo(metadataProvider, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.STATEFUL.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getStatefulFunctionInfo(metadataProvider, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.UNNEST.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getUnnestFunctionInfo(metadataProvider, function);
        }
        return finfo;
    }

    private static IFunctionInfo getScalarFunctionInfo(MetadataProvider metadataProvider, Function function) throws AlgebricksException {
        List<IAType> paramTypes = ExternalFunctionCompilerUtil.getParameterTypes(function, metadataProvider);
        IAType returnType = ExternalFunctionCompilerUtil.getType(function.getReturnType(), metadataProvider);
        ExternalTypeComputer typeComputer = new ExternalTypeComputer(returnType, paramTypes, function.getNullCall());
        ExternalFunctionLanguage lang = ExternalFunctionCompilerUtil.getExternalFunctionLanguage(function.getLanguage());
        Boolean deterministic = function.getDeterministic();
        if (deterministic == null) {
            throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{function.getSignature().toString()});
        }
        return new ExternalScalarFunctionInfo(function.getSignature().createFunctionIdentifier(), paramTypes, returnType, (IResultTypeComputer)typeComputer, lang, function.getLibraryDataverseName(), function.getLibraryName(), function.getExternalIdentifier(), function.getResources(), deterministic, function.getNullCall());
    }

    private static IFunctionInfo getUnnestFunctionInfo(MetadataProvider metadataProvider, Function function) {
        return null;
    }

    private static IFunctionInfo getStatefulFunctionInfo(MetadataProvider metadataProvider, Function function) {
        return null;
    }

    private static IFunctionInfo getAggregateFunctionInfo(MetadataProvider metadataProvider, Function function) {
        return null;
    }

    private static List<IAType> getParameterTypes(Function function, MetadataProvider metadataProvider) throws AlgebricksException {
        int arity = function.getArity();
        if (arity == 0) {
            return Collections.emptyList();
        }
        if (arity >= 0) {
            ArrayList<IAType> types = new ArrayList<IAType>(arity);
            List<TypeSignature> typeSignatures = function.getParameterTypes();
            if (typeSignatures != null) {
                if (typeSignatures.size() != arity) {
                    throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{function.getSignature().toString()});
                }
                for (TypeSignature ts : typeSignatures) {
                    IAType paramType = ExternalFunctionCompilerUtil.getType(ts, metadataProvider);
                    types.add(paramType);
                }
            } else {
                for (int i = 0; i < arity; ++i) {
                    types.add((IAType)BuiltinType.ANY);
                }
            }
            return types;
        }
        throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{function.getSignature().toString()});
    }

    private static IAType getType(TypeSignature typeSignature, MetadataProvider metadataProvider) throws AlgebricksException {
        if (typeSignature == null) {
            return BuiltinType.ANY;
        }
        String typeName = typeSignature.getName();
        if (BuiltinType.ANY.getTypeName().equals(typeName)) {
            return BuiltinType.ANY;
        }
        BuiltinType type = BuiltinTypeMap.getBuiltinType(typeName);
        if (type == null) {
            type = metadataProvider.findType(typeSignature.getDataverseName(), typeName);
        }
        return type;
    }

    public static ExternalFunctionLanguage getExternalFunctionLanguage(String language) throws AsterixException {
        try {
            return ExternalFunctionLanguage.valueOf((String)language);
        }
        catch (IllegalArgumentException e) {
            throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{language});
        }
    }

    public static void validateExternalIdentifier(List<String> externalIdentifier, ExternalFunctionLanguage language, SourceLocation sourceLoc) throws CompilationException {
        int expectedSize;
        switch (language) {
            case JAVA: {
                expectedSize = 1;
                break;
            }
            case PYTHON: {
                expectedSize = 2;
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.METADATA_ERROR, new Serializable[]{language.name()});
            }
        }
        int actualSize = externalIdentifier.size();
        if (actualSize != expectedSize) {
            throw new CompilationException(ErrorCode.INVALID_EXTERNAL_IDENTIFIER_SIZE, sourceLoc, new Serializable[]{String.valueOf(actualSize), language.name()});
        }
    }

    public static boolean supportsBatchInvocation(AbstractFunctionCallExpression.FunctionKind fnKind, IFunctionInfo fnInfo) throws CompilationException {
        if (fnKind != AbstractFunctionCallExpression.FunctionKind.SCALAR) {
            return false;
        }
        if (!fnInfo.isExternal()) {
            return false;
        }
        ExternalFunctionLanguage language = ((IExternalFunctionInfo)fnInfo).getLanguage();
        switch (language) {
            case JAVA: {
                return false;
            }
            case PYTHON: {
                return true;
            }
        }
        throw new CompilationException(ErrorCode.METADATA_ERROR, new Serializable[]{language.name()});
    }
}

