/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.refresher.AbstractRefresher;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.config.BucketStreamingRequest;
import com.couchbase.client.core.message.config.BucketStreamingResponse;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

public class HttpRefresher
extends AbstractRefresher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(HttpRefresher.class);
    private static final String TERSE_PATH = "/pools/default/bs/";
    private static final String VERBOSE_PATH = "/pools/default/bucketsStreaming/";

    public HttpRefresher(ClusterFacade cluster) {
        super(cluster);
    }

    @Override
    public Observable<Boolean> registerBucket(final String name, final String password) {
        Observable response = super.registerBucket(name, password).flatMap((Func1)new Func1<Boolean, Observable<BucketStreamingResponse>>(){

            public Observable<BucketStreamingResponse> call(Boolean aBoolean) {
                return HttpRefresher.this.cluster().send(new BucketStreamingRequest(HttpRefresher.TERSE_PATH, name, password)).doOnNext((Action1)new Action1<BucketStreamingResponse>(){

                    public void call(BucketStreamingResponse response) {
                        if (!response.status().isSuccess()) {
                            throw new ConfigurationException("Could not load terse config.");
                        }
                    }
                });
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<BucketStreamingResponse>>(){

            public Observable<BucketStreamingResponse> call(Throwable throwable) {
                return HttpRefresher.this.cluster().send(new BucketStreamingRequest(HttpRefresher.VERBOSE_PATH, name, password)).doOnNext((Action1)new Action1<BucketStreamingResponse>(){

                    public void call(BucketStreamingResponse response) {
                        if (!response.status().isSuccess()) {
                            throw new ConfigurationException("Could not load terse config.");
                        }
                    }
                });
            }
        });
        this.repeatConfigUntilUnsubscribed(name, (Observable<BucketStreamingResponse>)response);
        return response.map((Func1)new Func1<BucketStreamingResponse, Boolean>(){

            public Boolean call(BucketStreamingResponse response) {
                return response.status().isSuccess();
            }
        });
    }

    private void repeatConfigUntilUnsubscribed(final String name, Observable<BucketStreamingResponse> response) {
        response.flatMap((Func1)new Func1<BucketStreamingResponse, Observable<String>>(){

            public Observable<String> call(final BucketStreamingResponse response) {
                LOGGER.debug("Config stream started for {} on {}.", (Object)name, (Object)response.host());
                return response.configs().map((Func1)new Func1<String, String>(){

                    public String call(String s) {
                        return s.replace("$HOST", response.host());
                    }
                }).doOnCompleted(new Action0(){

                    public void call() {
                        LOGGER.debug("Config stream ended for {} on {}.", (Object)name, (Object)response.host());
                    }
                });
            }
        }).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Void> observable) {
                return observable.flatMap(new Func1<Void, Observable<?>>(){

                    public Observable<?> call(Void aVoid) {
                        if (HttpRefresher.this.registrations().containsKey(name)) {
                            LOGGER.debug("Resubscribing config stream for bucket {}, still registered.", (Object)name);
                            return Observable.just((Object)true);
                        }
                        LOGGER.debug("Not resubscribing config stream for bucket {}, not registered.", (Object)name);
                        return Observable.empty();
                    }
                });
            }
        }).subscribe((Action1)new Action1<String>(){

            public void call(String rawConfig) {
                HttpRefresher.this.pushConfig(rawConfig);
            }
        });
    }

    @Override
    public Observable<Boolean> shutdown() {
        return null;
    }

    @Override
    public void markTainted(BucketConfig config) {
    }

    @Override
    public void markUntainted(BucketConfig config) {
    }

    @Override
    public void refresh(ClusterConfig config) {
    }
}

