/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.util.ParseUtil;

public class SemiStructuredRecordReader
extends StreamRecordReader {
    private IWarningCollector warnings;
    private int depth;
    private boolean prevCharEscape;
    private boolean inString;
    private char recordStart;
    private char recordEnd;
    private boolean hasStarted;
    private boolean hasFinished;
    private boolean isLastCharCR;
    private State state = State.TOP_LEVEL;
    private long beginLineNumber = 1L;
    private long lineNumber = 1L;
    private static final List<String> recordReaderFormats = Collections.unmodifiableList(Arrays.asList("adm", "json", "JSON", "semi-structured"));
    private static final String REQUIRED_CONFIGS = "";

    @Override
    public void configure(IHyracksTaskContext ctx, AsterixInputStream stream, Map<String, String> config) throws HyracksDataException {
        super.configure(stream, config);
        stream.setNotificationHandler(this);
        this.warnings = ctx.getWarningCollector();
        this.recordStart = ExternalDataUtils.validateGetRecordStart(config);
        this.recordEnd = ExternalDataUtils.validateGetRecordEnd(config);
        if (this.recordStart == this.recordEnd) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{"record-end", Character.valueOf(this.recordEnd)});
        }
    }

    @Override
    public void notifyNewSource() {
        if (this.hasStarted && this.warnings.shouldWarn()) {
            ParseUtil.warn((IWarningCollector)this.warnings, (String)this.getPreviousStreamName(), (long)this.lineNumber, (int)0, (String)"malformed input record ended abruptly");
        }
        this.beginLineNumber = 1L;
        this.lineNumber = 1L;
        this.state = State.TOP_LEVEL;
        this.resetForNewRecord();
    }

    @Override
    public LongSupplier getLineNumber() {
        return this::getBeginLineNumber;
    }

    private long getBeginLineNumber() {
        return this.beginLineNumber;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        this.resetForNewRecord();
        this.beginLineNumber = this.lineNumber;
        do {
            int appendLength;
            char c;
            int startPosn = this.bufferPosn;
            if (this.bufferPosn >= this.bufferLength) {
                this.bufferPosn = 0;
                startPosn = 0;
                this.bufferLength = this.reader.read(this.inputBuffer);
                if (this.bufferLength < 0) {
                    if (this.hasStarted && this.warnings.shouldWarn()) {
                        ParseUtil.warn((IWarningCollector)this.warnings, (String)this.getDataSourceName().get(), (long)this.lineNumber, (int)0, (String)"malformed input record ended abruptly");
                    }
                    this.close();
                    return false;
                }
            }
            if (!this.hasStarted) {
                while (this.bufferPosn < this.bufferLength) {
                    c = this.inputBuffer[this.bufferPosn];
                    if (c == '\n' || this.isLastCharCR) {
                        ++this.lineNumber;
                    }
                    boolean bl = this.isLastCharCR = c == '\r';
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '\ufeff') {
                        if (c == this.recordStart && this.state != State.NESTED_OBJECT) {
                            if (this.state == State.ARRAY || this.state == State.AFTER_COMMA) {
                                this.state = State.NESTED_OBJECT;
                            }
                            this.beginLineNumber = this.lineNumber;
                            startPosn = this.bufferPosn++;
                            this.hasStarted = true;
                            this.depth = 1;
                            break;
                        }
                        if (c == '[' && this.state == State.TOP_LEVEL) {
                            this.state = State.ARRAY;
                        } else if (c == ']' && (this.state == State.ARRAY || this.state == State.NESTED_OBJECT)) {
                            this.state = State.TOP_LEVEL;
                        } else if (c == ',' && this.state == State.NESTED_OBJECT) {
                            this.state = State.AFTER_COMMA;
                        } else {
                            this.reader.reset();
                            this.bufferLength = 0;
                            this.bufferPosn = 0;
                            throw new RuntimeDataException(ErrorCode.RECORD_READER_MALFORMED_INPUT_STREAM, new Serializable[0]);
                        }
                    }
                    ++this.bufferPosn;
                }
            }
            if (!this.hasStarted) continue;
            while (this.bufferPosn < this.bufferLength) {
                c = this.inputBuffer[this.bufferPosn];
                if (c == '\n' || this.isLastCharCR) {
                    ++this.lineNumber;
                }
                if (this.inString) {
                    if (c == '\"' && !this.prevCharEscape) {
                        this.inString = false;
                    }
                    this.prevCharEscape = c == '\\' && !this.prevCharEscape;
                } else if (c == '\"') {
                    this.inString = true;
                } else if (c == this.recordStart) {
                    ++this.depth;
                } else if (c == this.recordEnd) {
                    --this.depth;
                    if (this.depth == 0) {
                        this.hasFinished = true;
                        ++this.bufferPosn;
                        break;
                    }
                }
                this.isLastCharCR = c == '\r';
                ++this.bufferPosn;
            }
            if ((appendLength = this.bufferPosn - startPosn) <= 0) continue;
            try {
                this.record.append(this.inputBuffer, startPosn, appendLength);
            }
            catch (RuntimeDataException e) {
                this.reader.reset();
                this.bufferLength = 0;
                this.bufferPosn = 0;
                throw e;
            }
        } while (!this.hasFinished);
        this.record.endRecord();
        return true;
    }

    @Override
    public List<String> getRecordReaderFormats() {
        return recordReaderFormats;
    }

    @Override
    public String getRequiredConfigs() {
        return REQUIRED_CONFIGS;
    }

    private void resetForNewRecord() {
        this.record.reset();
        this.hasStarted = false;
        this.hasFinished = false;
        this.prevCharEscape = false;
        this.isLastCharCR = false;
        this.inString = false;
        this.depth = 0;
    }

    private static enum State {
        TOP_LEVEL,
        ARRAY,
        NESTED_OBJECT,
        AFTER_COMMA;

    }
}

