/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.Serializable;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.library.ExternalScalarFunctionDescriptor;
import org.apache.asterix.om.functions.IExternalFunctionDescriptor;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;

public class ExternalFunctionDescriptorProvider {
    public static IExternalFunctionDescriptor resolveExternalFunction(AbstractFunctionCallExpression expr, IVariableTypeEnvironment inputTypeEnv, JobGenContext context) throws AlgebricksException {
        IExternalFunctionDescriptor fd = ExternalFunctionDescriptorProvider.getExternalFunctionDescriptor((IExternalFunctionInfo)expr.getFunctionInfo());
        CompilerProperties props = ((IApplicationContext)context.getAppContext()).getCompilerProperties();
        FunctionTypeInferers.SET_ARGUMENTS_TYPE.infer((ILogicalExpression)expr, (IFunctionDescriptor)fd, inputTypeEnv, props);
        fd.setSourceLocation(expr.getSourceLocation());
        return fd;
    }

    private static IExternalFunctionDescriptor getExternalFunctionDescriptor(IExternalFunctionInfo finfo) throws AlgebricksException {
        switch (finfo.getKind()) {
            case SCALAR: {
                return new ExternalScalarFunctionDescriptor(finfo);
            }
            case AGGREGATE: 
            case UNNEST: {
                throw new AsterixException(ErrorCode.LIBRARY_EXTERNAL_FUNCTION_UNSUPPORTED_KIND, new Serializable[]{finfo.getKind()});
            }
        }
        throw new AsterixException(ErrorCode.LIBRARY_EXTERNAL_FUNCTION_UNKNOWN_KIND, new Serializable[]{finfo.getKind()});
    }
}

