/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import reactor.core.publisher.Flux;

public final class BufferAggregator {
    private final long limit;
    private long length = 0L;
    private List<ByteBuffer> buffers = new LinkedList<ByteBuffer>();

    BufferAggregator(long limit) {
        this.limit = limit;
    }

    long remainingCapacity() {
        return this.limit - this.length;
    }

    public long length() {
        return this.length;
    }

    void append(ByteBuffer byteBuffer) {
        this.buffers.add(byteBuffer);
        this.length += (long)byteBuffer.remaining();
    }

    void reset() {
        this.length = 0L;
        this.buffers = new LinkedList<ByteBuffer>();
    }

    public Flux<ByteBuffer> asFlux() {
        return Flux.fromIterable(this.buffers);
    }
}

