/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.ApiCallContextOptions;
import com.google.api.gax.rpc.internal.Headers;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

@BetaApi
public final class HttpJsonCallContext
implements ApiCallContext {
    private final HttpJsonChannel channel;
    private final Duration timeout;
    private final Instant deadline;
    private final Credentials credentials;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiCallContextOptions options;
    private final ApiTracer tracer;
    private final RetrySettings retrySettings;
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    public static HttpJsonCallContext createDefault() {
        return new HttpJsonCallContext(null, null, null, null, (ImmutableMap<String, List<String>>)ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null);
    }

    private HttpJsonCallContext(HttpJsonChannel channel, Duration timeout, Instant deadline, Credentials credentials, ImmutableMap<String, List<String>> extraHeaders, ApiCallContextOptions options, ApiTracer tracer, RetrySettings defaultRetrySettings, Set<StatusCode.Code> defaultRetryableCodes) {
        this.channel = channel;
        this.timeout = timeout;
        this.deadline = deadline;
        this.credentials = credentials;
        this.extraHeaders = extraHeaders;
        this.options = options;
        this.tracer = tracer;
        this.retrySettings = defaultRetrySettings;
        this.retryableCodes = defaultRetryableCodes == null ? null : ImmutableSet.copyOf(defaultRetryableCodes);
    }

    public HttpJsonCallContext nullToSelf(ApiCallContext inputContext) {
        HttpJsonCallContext httpJsonCallContext;
        if (inputContext == null) {
            httpJsonCallContext = this;
        } else {
            if (!(inputContext instanceof HttpJsonCallContext)) {
                throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputContext.getClass().getName());
            }
            httpJsonCallContext = (HttpJsonCallContext)inputContext;
        }
        return httpJsonCallContext;
    }

    public HttpJsonCallContext merge(ApiCallContext inputCallContext) {
        ImmutableSet<StatusCode.Code> newRetryableCodes;
        RetrySettings newRetrySettings;
        Credentials newCredentials;
        Instant newDeadline;
        Duration newTimeout;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof HttpJsonCallContext)) {
            throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputCallContext.getClass().getName());
        }
        HttpJsonCallContext httpJsonCallContext = (HttpJsonCallContext)inputCallContext;
        HttpJsonChannel newChannel = httpJsonCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newTimeout = httpJsonCallContext.timeout) == null) {
            newTimeout = this.timeout;
        }
        if ((newDeadline = httpJsonCallContext.deadline) == null) {
            newDeadline = this.deadline;
        }
        if ((newCredentials = httpJsonCallContext.credentials) == null) {
            newCredentials = this.credentials;
        }
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, httpJsonCallContext.extraHeaders);
        ApiCallContextOptions newOptions = this.options.merge(httpJsonCallContext.options);
        ApiTracer newTracer = httpJsonCallContext.tracer;
        if (newTracer == null) {
            newTracer = this.tracer;
        }
        if ((newRetrySettings = httpJsonCallContext.retrySettings) == null) {
            newRetrySettings = this.retrySettings;
        }
        if ((newRetryableCodes = httpJsonCallContext.retryableCodes) == null) {
            newRetryableCodes = this.retryableCodes;
        }
        return new HttpJsonCallContext(newChannel, newTimeout, newDeadline, newCredentials, (ImmutableMap<String, List<String>>)newExtraHeaders, newOptions, newTracer, newRetrySettings, (Set<StatusCode.Code>)newRetryableCodes);
    }

    public HttpJsonCallContext withCredentials(Credentials newCredentials) {
        return new HttpJsonCallContext(this.channel, this.timeout, this.deadline, newCredentials, this.extraHeaders, this.options, this.tracer, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    public HttpJsonCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof HttpJsonTransportChannel)) {
            throw new IllegalArgumentException("Expected HttpJsonTransportChannel, got " + inputChannel.getClass().getName());
        }
        HttpJsonTransportChannel transportChannel = (HttpJsonTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public HttpJsonCallContext withTimeout(Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new HttpJsonCallContext(this.channel, timeout, this.deadline, this.credentials, this.extraHeaders, this.options, this.tracer, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    public ApiCallContext withStreamWaitTimeout(@Nonnull Duration streamWaitTimeout) {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    @Nullable
    public Duration getStreamWaitTimeout() {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    public ApiCallContext withStreamIdleTimeout(@Nonnull Duration streamIdleTimeout) {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    @Nullable
    public Duration getStreamIdleTimeout() {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public ApiCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new HttpJsonCallContext(this.channel, this.timeout, this.deadline, this.credentials, (ImmutableMap<String, List<String>>)newExtraHeaders, this.options, this.tracer, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    public <T> ApiCallContext withOption(ApiCallContext.Key<T> key, T value) {
        ApiCallContextOptions newOptions = this.options.withOption(key, value);
        return new HttpJsonCallContext(this.channel, this.timeout, this.deadline, this.credentials, this.extraHeaders, newOptions, this.tracer, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    public <T> T getOption(ApiCallContext.Key<T> key) {
        return (T)this.options.getOption(key);
    }

    public HttpJsonChannel getChannel() {
        return this.channel;
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public HttpJsonCallContext withRetrySettings(RetrySettings retrySettings) {
        return new HttpJsonCallContext(this.channel, this.timeout, this.deadline, this.credentials, this.extraHeaders, this.options, this.tracer, retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    public HttpJsonCallContext withRetryableCodes(Set<StatusCode.Code> retryableCodes) {
        return new HttpJsonCallContext(this.channel, this.timeout, this.deadline, this.credentials, this.extraHeaders, this.options, this.tracer, this.retrySettings, retryableCodes);
    }

    public HttpJsonCallContext withChannel(HttpJsonChannel newChannel) {
        return new HttpJsonCallContext(newChannel, this.timeout, this.deadline, this.credentials, this.extraHeaders, this.options, this.tracer, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    public HttpJsonCallContext withDeadline(Instant newDeadline) {
        return new HttpJsonCallContext(this.channel, this.timeout, newDeadline, this.credentials, this.extraHeaders, this.options, this.tracer, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    @Nonnull
    public ApiTracer getTracer() {
        if (this.tracer == null) {
            return BaseApiTracer.getInstance();
        }
        return this.tracer;
    }

    public HttpJsonCallContext withTracer(@Nonnull ApiTracer newTracer) {
        Preconditions.checkNotNull((Object)newTracer);
        return new HttpJsonCallContext(this.channel, this.timeout, this.deadline, this.credentials, this.extraHeaders, this.options, newTracer, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpJsonCallContext that = (HttpJsonCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.deadline, that.deadline) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.extraHeaders, that.extraHeaders) && Objects.equals(this.options, that.options) && Objects.equals(this.tracer, that.tracer) && Objects.equals(this.retrySettings, that.retrySettings) && Objects.equals(this.retryableCodes, that.retryableCodes);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.timeout, this.deadline, this.credentials, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }
}

