/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.function.BiConsumer;
import org.apache.hyracks.util.ThrowingBiFunction;

@FunctionalInterface
public interface ThrowingBiConsumer<L, R> {
    public void process(L var1, R var2) throws Exception;

    public static <L, R> BiConsumer<L, R> asUnchecked(ThrowingBiConsumer<L, R> consumer) {
        return (left, right) -> {
            try {
                consumer.process(left, right);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException((Throwable)e);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException((Throwable)e);
            }
        };
    }

    public static <I, J> ThrowingBiFunction<I, J, Void> asFunction(ThrowingBiConsumer<I, J> consumer) {
        return (p1, p2) -> {
            consumer.process(p1, p2);
            return null;
        };
    }
}

