/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.invertedlist;

import java.util.Iterator;
import org.apache.asterix.fuzzyjoin.invertedlist.InvertedList;

public class InvertedListLengthFixed
implements InvertedList {
    private final int[][] list;
    private int sz;
    private int ix;

    public InvertedListLengthFixed(int size) {
        this.list = new int[size * 3][3];
        this.sz = 0;
        this.ix = 0;
    }

    @Override
    public void add(int[] element) {
        this.list[this.sz++] = element;
    }

    public int getIndex() {
        return this.ix;
    }

    public int getSize() {
        return this.sz;
    }

    @Override
    public Iterator<int[]> iterator() {
        return new ListIterator(this.ix);
    }

    @Override
    public void setMinLength(int minLength) {
        while (this.ix < this.sz && this.list[this.ix][2] < minLength) {
            ++this.ix;
        }
    }

    public class ListIterator
    implements Iterator<int[]> {
        int ix;

        public ListIterator(int ix) {
            this.ix = ix;
        }

        @Override
        public boolean hasNext() {
            return this.ix < InvertedListLengthFixed.this.sz;
        }

        @Override
        public int[] next() {
            return InvertedListLengthFixed.this.list[this.ix++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

