/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.replication.api.IReplicationMessage;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PartitionResourcesListResponse
implements IReplicationMessage {
    private final int partition;
    private final Map<String, Long> partitionReplicatedResources;
    private final List<String> files;
    private final boolean owner;

    public PartitionResourcesListResponse(int partition, Map<String, Long> partitionReplicatedResources, List<String> files, boolean owner) {
        this.partition = partition;
        this.partitionReplicatedResources = partitionReplicatedResources;
        this.files = files;
        this.owner = owner;
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.PARTITION_RESOURCES_RESPONSE;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeInt(this.partition);
            dos.writeInt(this.files.size());
            for (String string : this.files) {
                dos.writeUTF(string);
            }
            dos.writeBoolean(this.owner);
            dos.writeInt(this.partitionReplicatedResources.size());
            for (Map.Entry entry : this.partitionReplicatedResources.entrySet()) {
                dos.writeUTF((String)entry.getKey());
                dos.writeLong((Long)entry.getValue());
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public List<String> getFiles() {
        return this.files;
    }

    public static PartitionResourcesListResponse create(DataInput input) throws IOException {
        int partition = input.readInt();
        int size = input.readInt();
        ArrayList<String> resources = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            resources.add(input.readUTF());
        }
        boolean owner = input.readBoolean();
        int resourceSize = input.readInt();
        HashMap<String, Long> partitionReplicatedResources = new HashMap<String, Long>();
        for (int i = 0; i < resourceSize; ++i) {
            partitionReplicatedResources.put(input.readUTF(), input.readLong());
        }
        return new PartitionResourcesListResponse(partition, partitionReplicatedResources, resources, owner);
    }

    public boolean isOrigin() {
        return this.owner;
    }

    public Map<String, Long> getPartitionReplicatedResources() {
        return this.partitionReplicatedResources;
    }
}

