/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABinarySerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.om.base.AUUID;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.util.bytes.Base64Printer;

public abstract class AbstractStringConstructorEvaluator
extends AbstractConstructorEvaluator {
    protected final UTF8StringBuilder builder = new UTF8StringBuilder();
    protected final GrowableArray baaos = new GrowableArray();
    protected final StringBuilder sb = new StringBuilder(32);

    protected AbstractStringConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        if (inputType == ATypeTag.STRING) {
            result.set((IValueReference)this.inputArg);
            return;
        }
        try {
            this.baaos.reset();
            this.builder.reset(this.baaos, len);
            this.sb.setLength(0);
            switch (inputType) {
                case TINYINT: {
                    byte i = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(startOffset + 1));
                    this.sb.append(i);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case SMALLINT: {
                    short i = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(startOffset + 1));
                    this.sb.append(i);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case INTEGER: {
                    int i = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(startOffset + 1));
                    this.sb.append(i);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case BIGINT: {
                    long l = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(startOffset + 1));
                    this.sb.append(l);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case DOUBLE: {
                    double d = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + 1));
                    if (Double.isNaN(d)) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NAN);
                        break;
                    }
                    if (d == Double.POSITIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.POSITIVE_INF);
                        break;
                    }
                    if (d == Double.NEGATIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NEGATIVE_INF);
                        break;
                    }
                    this.sb.append(d);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case FLOAT: {
                    float f = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(startOffset + 1));
                    if (Float.isNaN(f)) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NAN);
                        break;
                    }
                    if (f == Float.POSITIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.POSITIVE_INF);
                        break;
                    }
                    if (f == Float.NEGATIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NEGATIVE_INF);
                        break;
                    }
                    this.sb.append(f);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case BOOLEAN: {
                    boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])bytes, (int)(startOffset + 1));
                    this.builder.appendString((CharSequence)String.valueOf(b));
                    break;
                }
                case DATE: {
                    long l = (long)ADateSerializerDeserializer.getChronon((byte[])bytes, (int)(startOffset + 1)) * 86400000L;
                    GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(l, (Appendable)this.sb, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.DAY);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case TIME: {
                    int i = ATimeSerializerDeserializer.getChronon((byte[])bytes, (int)(startOffset + 1));
                    GregorianCalendarSystem.getInstance().getExtendStringRepUntilField((long)i, (Appendable)this.sb, GregorianCalendarSystem.Fields.HOUR, GregorianCalendarSystem.Fields.MILLISECOND);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case DATETIME: {
                    long l = ADateTimeSerializerDeserializer.getChronon((byte[])bytes, (int)(startOffset + 1));
                    GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(l, (Appendable)this.sb, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.MILLISECOND);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case YEARMONTHDURATION: {
                    int i = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1));
                    GregorianCalendarSystem.getInstance().getDurationExtendStringRepWithTimezoneUntilField(0L, i, this.sb);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case DAYTIMEDURATION: {
                    long l = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes, (int)(startOffset + 1));
                    GregorianCalendarSystem.getInstance().getDurationExtendStringRepWithTimezoneUntilField(l, 0, this.sb);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case DURATION: {
                    int i = ADurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1));
                    long l = ADurationSerializerDeserializer.getDayTime((byte[])bytes, (int)(startOffset + 1));
                    GregorianCalendarSystem.getInstance().getDurationExtendStringRepWithTimezoneUntilField(l, i, this.sb);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case UUID: {
                    AUUID.appendLiteralOnly((byte[])bytes, (int)(startOffset + 1), (Appendable)this.sb);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                case BINARY: {
                    int contentLength = ABinarySerializerDeserializer.getContentLength((byte[])bytes, (int)(startOffset + 1));
                    int metaLength = ABinarySerializerDeserializer.getMetaLength((int)contentLength);
                    Base64Printer.printBase64Binary((byte[])bytes, (int)(startOffset + 1 + metaLength), (int)contentLength, (Appendable)this.sb);
                    this.builder.appendString((CharSequence)this.sb);
                    break;
                }
                default: {
                    this.handleUnsupportedType(inputType, result);
                    return;
                }
            }
            this.builder.finish();
            this.resultStorage.reset();
            this.out.write(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            this.out.write(this.baaos.getByteArray(), 0, this.baaos.getLength());
            result.set((IValueReference)this.resultStorage);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    protected BuiltinType getTargetType() {
        return BuiltinType.ASTRING;
    }
}

