/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.ipc.NodeControllerRemoteProxy;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterNodeWork
extends SynchronizableWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final NodeRegistration reg;
    private final int registrationId;

    public RegisterNodeWork(ClusterControllerService ccs, NodeRegistration reg, int registrationId) {
        this.ccs = ccs;
        this.reg = reg;
        this.registrationId = registrationId;
    }

    protected void doRun() throws Exception {
        String id = this.reg.getNodeId();
        LOGGER.info("registering node: {}", (Object)id);
        InetSocketAddress ncAddress = this.reg.getNodeControllerAddress().toInetSocketAddress();
        NodeControllerRemoteProxy nc = new NodeControllerRemoteProxy(this.ccs.getCcId(), this.ccs.getClusterIPC().getReconnectingHandle(ncAddress));
        INodeManager nodeManager = this.ccs.getNodeManager();
        NodeParameters params = new NodeParameters();
        params.setClusterControllerInfo(this.ccs.getClusterControllerInfo());
        params.setDistributedState(this.ccs.getContext().getDistributedState());
        params.setHeartbeatPeriod(this.ccs.getCCConfig().getHeartbeatPeriodMillis());
        params.setProfileDumpPeriod(this.ccs.getCCConfig().getProfileDumpPeriod());
        params.setRegistrationId(this.registrationId);
        try {
            NodeControllerState state = new NodeControllerState(nc, this.reg);
            nodeManager.addNode(id, state);
            HashMap<IOption, Object> ncConfiguration = new HashMap<IOption, Object>();
            ConfigManager configManager = this.ccs.getConfig().getConfigManager();
            state.getConfig().forEach((key, value) -> {
                IOption option = configManager.lookupOption(key);
                if (option == null) {
                    LOGGER.info("discarding unknown option {}", key);
                } else {
                    ncConfiguration.put(option, value);
                }
            });
            LOGGER.info("registered node: {}", (Object)id);
            nc.sendRegistrationResult(params, null);
            this.ccs.getContext().notifyNodeJoin(id, ncConfiguration);
        }
        catch (Exception e) {
            LOGGER.error("node {} registration failed", (Object)id, (Object)e);
            nodeManager.removeNode(id);
            nc.sendRegistrationResult(params, e);
        }
    }

    public Level logLevel() {
        return Level.TRACE;
    }
}

