/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Info {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AtomicInteger referenceCount = new AtomicInteger();
    private volatile boolean isOpen = false;

    public void touch() {
        this.referenceCount.incrementAndGet();
    }

    public void untouch() {
        int currentRefCount = this.referenceCount.get();
        if (currentRefCount <= 0) {
            LOGGER.warn("trying to decrement ref count {} that is already <=0", (Object)currentRefCount);
        }
        this.referenceCount.updateAndGet(i -> i > 0 ? i - 1 : i);
    }

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }
}

