/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.btree;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.AbstractColumnBTreeLeafFrame;

public class ColumnBTreeWriteLeafFrame
extends AbstractColumnBTreeLeafFrame {
    private final AbstractColumnTupleWriter columnTupleWriter;

    public ColumnBTreeWriteLeafFrame(ITreeIndexTupleWriter rowTupleWriter, AbstractColumnTupleWriter columnTupleWriter) {
        super(rowTupleWriter);
        this.columnTupleWriter = columnTupleWriter;
    }

    @Override
    public void initBuffer(byte level) {
        this.buf.putInt(0, 0);
        this.buf.put(8, level);
        this.buf.putInt(4, 0);
        this.buf.putInt(9, -1);
        this.buf.putInt(13, -1);
        this.buf.putInt(17, 0);
        this.buf.putInt(21, 0);
        this.buf.put(25, (byte)0);
        this.buf.putInt(26, -1);
    }

    void flush(AbstractColumnTupleWriter columnWriter, int numberOfTuples, IColumnWriteMultiPageOp multiPageOp, ITupleReference minKey, ITupleReference maxKey) throws HyracksDataException {
        this.buf.position(30);
        columnWriter.flush(this.buf);
        int offset = this.buf.position();
        this.buf.putInt(9, offset);
        offset += this.rowTupleWriter.writeTuple(minKey, this.buf.array(), offset);
        this.buf.putInt(13, offset);
        this.rowTupleWriter.writeTuple(maxKey, this.buf.array(), offset);
        int numberOfColumns = columnWriter.getNumberOfColumns();
        this.buf.putInt(0, numberOfTuples);
        this.buf.putInt(4, numberOfColumns);
        this.buf.putInt(17, columnWriter.getColumnOffsetsSize());
        this.buf.putInt(21, multiPageOp.getNumberOfPersistentBuffers());
    }

    public AbstractColumnTupleWriter getColumnTupleWriter() {
        return this.columnTupleWriter;
    }

    void setNextLeaf(int pageId) {
        this.buf.putInt(26, pageId);
    }
}

