/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;

class GoogleHadoopFSInputStream
extends FSInputStream {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final SeekableByteChannel channel;
    private URI gcsPath;
    private long totalBytesRead;
    private final FileSystem.Statistics statistics;
    private final byte[] singleReadBuf = new byte[1];

    GoogleHadoopFSInputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, GoogleCloudStorageReadOptions readOptions, FileSystem.Statistics statistics) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleHadoopFSInputStream(gcsPath: %s, readOptions: %s)", (Object)gcsPath, (Object)readOptions);
        this.gcsPath = gcsPath;
        this.statistics = statistics;
        this.totalBytesRead = 0L;
        this.channel = ghfs.getGcsFs().open(gcsPath, readOptions);
    }

    public synchronized int read() throws IOException {
        int numRead = this.channel.read(ByteBuffer.wrap(this.singleReadBuf));
        if (numRead == -1) {
            return -1;
        }
        if (numRead != 1) {
            throw new IOException(String.format("Somehow read %d bytes using single-byte buffer for path %s ending in position %d!", numRead, this.gcsPath, this.channel.position()));
        }
        byte b = this.singleReadBuf[0];
        ++this.totalBytesRead;
        this.statistics.incrementBytesRead(1L);
        this.statistics.incrementReadOps(1);
        return b & 0xFF;
    }

    public synchronized int read(byte[] buf, int offset, int length) throws IOException {
        Preconditions.checkNotNull((Object)buf, (Object)"buf must not be null");
        if (offset < 0 || length < 0 || length > buf.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        int numRead = this.channel.read(ByteBuffer.wrap(buf, offset, length));
        if (numRead > 0) {
            this.statistics.incrementBytesRead((long)numRead);
            this.statistics.incrementReadOps(1);
            this.totalBytesRead += (long)numRead;
        }
        return numRead;
    }

    public synchronized int read(long position, byte[] buf, int offset, int length) throws IOException {
        int result = super.read(position, buf, offset, length);
        if (result > 0) {
            this.statistics.incrementBytesRead((long)result);
            this.totalBytesRead += (long)result;
        }
        return result;
    }

    public synchronized long getPos() throws IOException {
        long pos = this.channel.position();
        ((GoogleLogger.Api)logger.atFiner()).log("getPos(): %d", pos);
        return pos;
    }

    public synchronized void seek(long pos) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("seek(%d)", pos);
        try {
            this.channel.position(pos);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized void close() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("close(): %s", (Object)this.gcsPath);
        if (this.channel != null) {
            ((GoogleLogger.Api)logger.atFiner()).log("Closing '%s' file with %d total bytes read", (Object)this.gcsPath, this.totalBytesRead);
            this.channel.close();
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        return super.available();
    }
}

