/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.app.message.VoidResponse;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.messaging.CcIdentifiedMessage;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageCleanupRequestMessage
extends CcIdentifiedMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final IntOpenHashSet validDatasetIds;
    private final long reqId;

    public StorageCleanupRequestMessage(long reqId, IntOpenHashSet validDatasetIds) {
        this.validDatasetIds = validDatasetIds;
        this.reqId = reqId;
    }

    public void handle(INcApplicationContext appContext) throws HyracksDataException, InterruptedException {
        INCMessageBroker broker = (INCMessageBroker)appContext.getServiceContext().getMessageBroker();
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)appContext.getLocalResourceRepository();
        Set nodePartitions = appContext.getReplicaManager().getPartitions();
        Map localResources = localResourceRepository.getResources(lr -> true, nodePartitions);
        for (LocalResource resource : localResources.values()) {
            DatasetLocalResource lr2 = (DatasetLocalResource)resource.getResource();
            if (MetadataIndexImmutableProperties.isMetadataDataset((int)lr2.getDatasetId()) || this.validDatasetIds.contains(lr2.getDatasetId())) continue;
            LOGGER.warn("found invalid index {} with dataset id {}", (Object)resource.getPath(), (Object)lr2.getDatasetId());
            this.deleteInvalidIndex(appContext, localResourceRepository, resource);
        }
        for (Integer partition : nodePartitions) {
            localResourceRepository.cleanup(partition.intValue());
        }
        try {
            broker.sendMessageToPrimaryCC((ICcAddressedMessage)new VoidResponse(this.reqId, null));
        }
        catch (Exception e) {
            LOGGER.error("failed to notify CC of storage clean up; halting...", (Throwable)e);
            ExitUtil.halt((int)19);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInvalidIndex(INcApplicationContext appContext, PersistentLocalResourceRepository localResourceRepository, LocalResource resource) throws HyracksDataException {
        IDatasetLifecycleManager lcManager = appContext.getDatasetLifecycleManager();
        String resourceRelPath = resource.getPath();
        IDatasetLifecycleManager iDatasetLifecycleManager = lcManager;
        synchronized (iDatasetLifecycleManager) {
            IIndex index = (IIndex)lcManager.get(resourceRelPath);
            if (index != null) {
                LOGGER.warn("unregistering invalid index {}", (Object)resourceRelPath);
                lcManager.unregister(resourceRelPath);
            } else {
                LOGGER.warn("initializing unregistered invalid index {}", (Object)resourceRelPath);
                try {
                    index = resource.getResource().createInstance(appContext.getServiceContext());
                }
                catch (Exception e) {
                    LOGGER.warn("failed to initialize invalid index {}", (Object)resourceRelPath, (Object)e);
                }
            }
            localResourceRepository.delete(resourceRelPath);
            if (index != null) {
                index.destroy();
            }
        }
    }

    public String toString() {
        return StorageCleanupRequestMessage.class.getSimpleName();
    }
}

