/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.asterix.common.config.AsterixProperties;
import org.apache.asterix.common.config.BuildProperties;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.hyracks.bootstrap.CCApplication;
import org.apache.asterix.hyracks.bootstrap.NCApplication;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationConfigurator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String APPLICATION_NAME = "Apache AsterixDB";

    private ApplicationConfigurator() {
    }

    static void registerConfigOptions(IConfigManager configManager) {
        AsterixProperties.registerConfigOptions((IConfigManager)configManager);
        ControllerConfig.Option.DEFAULT_DIR.setDefaultValue(FileUtil.joinPath((String[])new String[]{System.getProperty("java.io.tmpdir"), "asterixdb"}));
        NCConfig.Option.APP_CLASS.setDefaultValue((Object)NCApplication.class.getName());
        CCConfig.Option.APP_CLASS.setDefaultValue((Object)CCApplication.class.getName());
        try {
            InputStream propertyStream = ApplicationConfigurator.class.getClassLoader().getResourceAsStream("git.properties");
            if (propertyStream != null) {
                Properties gitProperties = new Properties();
                gitProperties.load(propertyStream);
                StringWriter sw = new StringWriter();
                gitProperties.store(sw, null);
                configManager.setVersionString(sw.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void validateJavaRuntime() throws HyracksDataException {
        String javaVersion = System.getProperty("java.version");
        LOGGER.info("Found JRE version " + javaVersion);
        String[] splits = javaVersion.split("\\.");
        switch (splits[0]) {
            case "1": {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.UNSUPPORTED_JRE, (Serializable[])new Serializable[]{"a minimum version of JRE of 11 is required, but is currently: \"" + javaVersion + "\""});
            }
            case "11": 
            case "17": {
                break;
            }
            default: {
                LOGGER.warn("JRE version \"" + javaVersion + "\" is untested");
            }
        }
    }

    public static String getApplicationVersion(BuildProperties buildProperties) {
        return (String)buildProperties.getAllProps().get("git.build.version");
    }
}

