/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import org.apache.asterix.column.assembler.AbstractPrimitiveValueAssembler;
import org.apache.asterix.column.assembler.ArrayValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.column.assembler.AssemblerState;
import org.apache.asterix.column.assembler.value.MissingValueGetter;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class EndOfRepeatedGroupAssembler
extends AbstractPrimitiveValueAssembler {
    private final ArrayValueAssembler arrayAssembler;
    private final int delimiterIndex;
    private EndOfRepeatedGroupAssembler previousGroup;

    EndOfRepeatedGroupAssembler(IColumnValuesReader reader, ArrayValueAssembler arrayAssembler, int delimiterIndex) {
        super(reader.getLevel(), new AssemblerInfo(), reader, MissingValueGetter.INSTANCE);
        this.arrayAssembler = arrayAssembler;
        this.delimiterIndex = delimiterIndex;
        this.previousGroup = null;
    }

    @Override
    public void reset(AbstractBytesInputStream in, int numberOfTuples) throws HyracksDataException {
    }

    @Override
    public int next(AssemblerState state) throws HyracksDataException {
        int delimiterIndex = this.reader.getDelimiterIndex();
        if (delimiterIndex > this.delimiterIndex) {
            if (this.arrayAssembler.isDelegate()) {
                this.arrayAssembler.end();
            }
            return -1;
        }
        int nextIndex = -1;
        if (this.reader.isDelimiter() && delimiterIndex == this.delimiterIndex) {
            this.arrayAssembler.end();
            state.exitRepeatedGroup(this.previousGroup);
        } else {
            nextIndex = this.arrayAssembler.getFirstValueIndex();
            if (!state.isCurrentGroup(this)) {
                this.previousGroup = state.enterRepeatedGroup(this);
            }
        }
        return nextIndex;
    }

    @Override
    public void skip(int count) throws HyracksDataException {
    }
}

