/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.decoder;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;

public class ParquetRunLengthBitPackingHybridDecoder {
    private final int bitWidth;
    private final BytePacker packer;
    private InputStream in;
    private MODE mode;
    private int currentCount;
    private int currentValue;
    private int currentBufferLength;
    private int[] currentBuffer;
    private byte[] bytes;

    public ParquetRunLengthBitPackingHybridDecoder(int bitWidth) {
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (String)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bitWidth;
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
    }

    public void reset(InputStream in) {
        this.in = in;
        this.currentCount = 0;
        this.currentBufferLength = 0;
    }

    public int readInt() throws HyracksDataException {
        try {
            return this.nextInt();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private int nextInt() throws IOException {
        int result;
        if (this.currentCount == 0) {
            this.readNext();
        }
        --this.currentCount;
        switch (this.mode) {
            case RLE: {
                result = this.currentValue;
                break;
            }
            case PACKED: {
                result = this.currentBuffer[this.currentBufferLength - 1 - this.currentCount];
                break;
            }
            default: {
                throw new ParquetDecodingException("not a valid mode " + this.mode);
            }
        }
        return result;
    }

    private void readNext() throws IOException {
        Preconditions.checkArgument((this.in.available() > 0 ? 1 : 0) != 0, (String)"Reading past RLE/BitPacking stream.");
        int header = BytesUtils.readUnsignedVarInt((InputStream)this.in);
        this.mode = (header & 1) == 0 ? MODE.RLE : MODE.PACKED;
        switch (this.mode) {
            case RLE: {
                this.currentCount = header >>> 1;
                this.currentValue = BytesUtils.readIntLittleEndianPaddedOnBitWidth((InputStream)this.in, (int)this.bitWidth);
                break;
            }
            case PACKED: {
                int numGroups = header >>> 1;
                this.currentCount = numGroups * 8;
                this.allocateBuffers(this.currentCount, numGroups * this.bitWidth);
                int bytesToRead = (int)Math.ceil((double)(this.currentCount * this.bitWidth) / 8.0);
                bytesToRead = Math.min(bytesToRead, this.in.available());
                this.readFully(this.bytes, bytesToRead);
                int valueIndex = 0;
                int byteIndex = 0;
                while (valueIndex < this.currentCount) {
                    this.packer.unpack8Values(this.bytes, byteIndex, this.currentBuffer, valueIndex);
                    valueIndex += 8;
                    byteIndex += this.bitWidth;
                }
                break;
            }
            default: {
                throw new ParquetDecodingException("not a valid mode " + this.mode);
            }
        }
    }

    private void allocateBuffers(int intBufferLength, int byteBufferLength) {
        if (this.currentBuffer == null || this.currentBuffer.length < intBufferLength) {
            this.currentBuffer = new int[intBufferLength];
        } else {
            Arrays.fill(this.currentBuffer, 0);
        }
        this.currentBufferLength = intBufferLength;
        if (this.bytes == null || this.bytes.length < byteBufferLength) {
            this.bytes = new byte[byteBufferLength];
        } else {
            Arrays.fill(this.bytes, (byte)0);
        }
    }

    private void readFully(byte[] b, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private static enum MODE {
        RLE,
        PACKED;

    }
}

