/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.encoder;

import org.apache.asterix.column.bytes.encoder.AbstractParquetValuesWriter;
import org.apache.asterix.column.bytes.encoder.ParquetDeltaBinaryPackingValuesWriterForInteger;
import org.apache.asterix.column.bytes.encoder.ParquetDeltaLengthByteArrayValuesWriter;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.parquet.bytes.BytesInput;

public class ParquetDeltaByteArrayWriter
extends AbstractParquetValuesWriter {
    private static final IValueReference EMPTY_VALUE;
    private final ParquetDeltaBinaryPackingValuesWriterForInteger prefixLengthWriter;
    private final ParquetDeltaLengthByteArrayValuesWriter suffixWriter;
    private final VoidPointable suffix;
    private final ArrayBackedValueStorage previous = new ArrayBackedValueStorage();

    public ParquetDeltaByteArrayWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this.prefixLengthWriter = new ParquetDeltaBinaryPackingValuesWriterForInteger(multiPageOpRef);
        this.suffixWriter = new ParquetDeltaLengthByteArrayValuesWriter(multiPageOpRef);
        this.suffix = new VoidPointable();
        this.suffix.set(EMPTY_VALUE);
    }

    @Override
    public BytesInput getBytes() {
        BytesInput prefixBytes = this.prefixLengthWriter.getBytes();
        BytesInput prefixLength = BytesInput.fromUnsignedVarInt((int)((int)prefixBytes.size()));
        BytesInput suffixBytes = this.suffixWriter.getBytes();
        return BytesInput.concat((BytesInput[])new BytesInput[]{prefixLength, prefixBytes, suffixBytes});
    }

    @Override
    public void reset() throws HyracksDataException {
        this.prefixLengthWriter.reset();
        this.suffixWriter.reset();
        this.previous.reset();
        this.suffix.set(EMPTY_VALUE);
    }

    @Override
    public void close() {
        this.prefixLengthWriter.close();
        this.suffixWriter.close();
        this.previous.reset();
        this.suffix.set(EMPTY_VALUE);
    }

    @Override
    public int getEstimatedSize() {
        return this.prefixLengthWriter.getEstimatedSize() + this.suffixWriter.getEstimatedSize();
    }

    @Override
    public int getAllocatedSize() {
        return this.prefixLengthWriter.getAllocatedSize() + this.suffixWriter.getAllocatedSize();
    }

    @Override
    public void writeBytes(IValueReference value, boolean skipLengthBytes) {
        byte[] bytes = value.getByteArray();
        int start = value.getStartOffset();
        int length = value.getLength();
        if (skipLengthBytes) {
            int lengthBytes = UTF8StringUtil.getNumBytesToStoreLength((byte[])bytes, (int)start);
            start += lengthBytes;
            length -= lengthBytes;
        }
        this.writeBytes(bytes, start, length);
    }

    private void writeBytes(byte[] bytes, int offset, int length) {
        int i;
        byte[] prevBytes = this.previous.getByteArray();
        int prevOffset = this.previous.getStartOffset();
        int minLength = Math.min(length, this.previous.getLength());
        for (i = 0; i < minLength && bytes[i + offset] == prevBytes[i + prevOffset]; ++i) {
        }
        this.prefixLengthWriter.writeInteger(i);
        this.suffix.set(bytes, offset + i, length - i);
        this.suffixWriter.writeBytes((IValueReference)this.suffix, false);
        this.previous.set(bytes, offset, length);
    }

    static {
        VoidPointable emptyPointable = new VoidPointable();
        emptyPointable.set(new byte[0], 0, 0);
        EMPTY_VALUE = emptyPointable;
    }
}

