/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.encoder;

import java.io.IOException;
import org.apache.asterix.column.bytes.encoder.AbstractParquetValuesWriter;
import org.apache.asterix.column.bytes.stream.out.AbstractBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.MultiTemporaryBufferBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.ValueOutputStream;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.io.ParquetEncodingException;

public class ParquetPlainFixedLengthValuesWriter
extends AbstractParquetValuesWriter {
    private final AbstractBytesOutputStream outputStream;
    private final ValueOutputStream out;

    public ParquetPlainFixedLengthValuesWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this.outputStream = new MultiTemporaryBufferBytesOutputStream(multiPageOpRef);
        this.out = new ValueOutputStream(this.outputStream);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.out.writeInt(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write int", (Throwable)e);
        }
    }

    @Override
    public void writeLong(long v) {
        try {
            this.out.writeLong(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write long", (Throwable)e);
        }
    }

    @Override
    public void writeFloat(float v) {
        try {
            this.out.writeFloat(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write int", (Throwable)e);
        }
    }

    @Override
    public final void writeDouble(double v) {
        try {
            this.out.writeDouble(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write double", (Throwable)e);
        }
    }

    @Override
    public void writeBytes(IValueReference v, boolean skipLengthBytes) {
        try {
            this.out.write(v.getByteArray(), v.getStartOffset(), v.getLength());
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write bytes", (Throwable)e);
        }
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", (Throwable)e);
        }
        return this.outputStream.asBytesInput();
    }

    @Override
    public void reset() throws HyracksDataException {
        this.outputStream.reset();
    }

    @Override
    public void close() {
        this.outputStream.finish();
    }

    @Override
    public int getEstimatedSize() {
        return this.outputStream.size();
    }

    @Override
    public int getAllocatedSize() {
        return this.outputStream.capacity();
    }
}

