/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.encoder;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.column.bytes.stream.out.GrowableBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.pointer.IReservedPointer;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;

public class ParquetRunLengthBitPackingHybridEncoder {
    private final BytePacker packer;
    private final GrowableBytesOutputStream outputStream;
    private final int bitWidth;
    private final byte[] packBuffer;
    private int previousValue;
    private final int[] bufferedValues;
    private int numBufferedValues;
    private int repeatCount;
    private int bitPackedGroupCount;
    private final IReservedPointer bitPackedRunHeaderPointer;
    private boolean toBytesCalled;

    public ParquetRunLengthBitPackingHybridEncoder(int bitWidth) {
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (String)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bitWidth;
        this.outputStream = new GrowableBytesOutputStream();
        this.bitPackedRunHeaderPointer = this.outputStream.createPointer();
        this.packBuffer = new byte[bitWidth];
        this.bufferedValues = new int[8];
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
        this.reset(false);
    }

    private void reset(boolean resetBaos) {
        if (resetBaos) {
            this.outputStream.reset();
        }
        this.previousValue = 0;
        this.numBufferedValues = 0;
        this.repeatCount = 0;
        this.bitPackedGroupCount = 0;
        this.bitPackedRunHeaderPointer.reset();
        this.toBytesCalled = false;
    }

    public void writeInt(int value) throws IOException {
        if (value == this.previousValue) {
            ++this.repeatCount;
            if (this.repeatCount >= 8) {
                return;
            }
        } else {
            if (this.repeatCount >= 8) {
                this.writeRleRun();
            }
            this.repeatCount = 1;
            this.previousValue = value;
        }
        this.bufferedValues[this.numBufferedValues] = value;
        ++this.numBufferedValues;
        if (this.numBufferedValues == 8) {
            this.writeOrAppendBitPackedRun();
        }
    }

    private void writeOrAppendBitPackedRun() throws IOException {
        if (this.bitPackedGroupCount >= 63) {
            this.endPreviousBitPackedRun();
        }
        if (!this.bitPackedRunHeaderPointer.isSet()) {
            this.outputStream.reserveByte(this.bitPackedRunHeaderPointer);
        }
        this.packer.pack8Values(this.bufferedValues, 0, this.packBuffer, 0);
        this.outputStream.write(this.packBuffer);
        this.numBufferedValues = 0;
        this.repeatCount = 0;
        ++this.bitPackedGroupCount;
    }

    private void endPreviousBitPackedRun() {
        if (!this.bitPackedRunHeaderPointer.isSet()) {
            return;
        }
        byte bitPackHeader = (byte)(this.bitPackedGroupCount << 1 | 1);
        this.bitPackedRunHeaderPointer.setByte(bitPackHeader);
        this.bitPackedRunHeaderPointer.reset();
        this.bitPackedGroupCount = 0;
    }

    private void writeRleRun() throws IOException {
        this.endPreviousBitPackedRun();
        BytesUtils.writeUnsignedVarInt((int)(this.repeatCount << 1), (OutputStream)this.outputStream);
        BytesUtils.writeIntLittleEndianPaddedOnBitWidth((OutputStream)this.outputStream, (int)this.previousValue, (int)this.bitWidth);
        this.repeatCount = 0;
        this.numBufferedValues = 0;
    }

    public BytesInput toBytes() throws IOException {
        Preconditions.checkArgument((!this.toBytesCalled ? 1 : 0) != 0, (String)"You cannot call toBytes() more than once without calling reset()");
        if (this.repeatCount >= 8) {
            this.writeRleRun();
        } else if (this.numBufferedValues > 0) {
            for (int i = this.numBufferedValues; i < 8; ++i) {
                this.bufferedValues[i] = 0;
            }
            this.writeOrAppendBitPackedRun();
            this.endPreviousBitPackedRun();
        } else {
            this.endPreviousBitPackedRun();
        }
        this.toBytesCalled = true;
        return this.outputStream.asBytesInput();
    }

    public void reset() {
        this.reset(true);
    }

    public void close() {
        this.reset(false);
        this.outputStream.finish();
    }

    public int getEstimatedSize() {
        return this.outputStream.size() + this.repeatCount * this.bitWidth;
    }

    public int getAllocatedSize() {
        return this.outputStream.capacity();
    }
}

