/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.assembler.value.IValueGetterFactory;
import org.apache.asterix.column.filter.iterable.accessor.ColumnFilterValueAccessorEvaluator;
import org.apache.asterix.column.filter.iterable.accessor.MissingEvaluator;
import org.apache.asterix.column.filter.iterable.accessor.UnionColumnFilterValueAccessorEvaluator;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessor;
import org.apache.asterix.column.filter.range.accessor.ColumnRangeFilterValueAccessor;
import org.apache.asterix.column.filter.range.accessor.MissingColumnRangeFilterValueAccessor;
import org.apache.asterix.column.filter.range.accessor.NoOpColumnRangeFilterValueAccessor;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.MissingFieldSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.column.metadata.schema.visitor.PathExtractorVisitor;
import org.apache.asterix.column.metadata.schema.visitor.SchemaClipperVisitor;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesReaderFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FilterAccessorProvider {
    private final ObjectSchemaNode root;
    private final ObjectSchemaNode metaRoot;
    private final SchemaClipperVisitor clipperVisitor;
    private final PathExtractorVisitor pathExtractorVisitor;
    private final Map<ARecordType, PrimitiveSchemaNode> cachedNodes;
    private final List<IColumnRangeFilterValueAccessor> filterAccessors;
    private final List<IColumnValuesReader> filterColumnReaders;
    private final IValueGetterFactory valueGetterFactory;

    public FilterAccessorProvider(ObjectSchemaNode root, SchemaClipperVisitor clipperVisitor, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory) {
        this(root, null, clipperVisitor, readerFactory, valueGetterFactory);
    }

    public FilterAccessorProvider(ObjectSchemaNode root, ObjectSchemaNode metaRoot, SchemaClipperVisitor clipperVisitor, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory) {
        this.root = root;
        this.metaRoot = metaRoot;
        this.clipperVisitor = clipperVisitor;
        this.valueGetterFactory = valueGetterFactory;
        this.pathExtractorVisitor = new PathExtractorVisitor(readerFactory);
        this.cachedNodes = new HashMap<ARecordType, PrimitiveSchemaNode>();
        this.filterAccessors = new ArrayList<IColumnRangeFilterValueAccessor>();
        this.filterColumnReaders = new ArrayList<IColumnValuesReader>();
    }

    public void reset() {
        this.cachedNodes.clear();
    }

    public IColumnRangeFilterValueAccessor createRangeFilterValueAccessor(ARecordType path, boolean min) throws HyracksDataException {
        PrimitiveSchemaNode node = this.cachedNodes.get(path);
        if (node == null) {
            AbstractSchemaNode pathNode = this.getNode(path);
            node = (PrimitiveSchemaNode)(pathNode.isNested() ? MissingFieldSchemaNode.INSTANCE : pathNode);
            this.cachedNodes.put(path, node);
        }
        if (node.isPrimaryKey()) {
            return NoOpColumnRangeFilterValueAccessor.INSTANCE;
        }
        ATypeTag typeTag = node.getTypeTag();
        if (typeTag == ATypeTag.MISSING) {
            return MissingColumnRangeFilterValueAccessor.INSTANCE;
        }
        ColumnRangeFilterValueAccessor accessor = new ColumnRangeFilterValueAccessor(node.getColumnIndex(), typeTag, min);
        this.filterAccessors.add(accessor);
        return accessor;
    }

    public IScalarEvaluator createColumnAccessEvaluator(ARecordType path) throws HyracksDataException {
        List<IColumnValuesReader> readers = this.createReaders(path);
        if (readers.isEmpty()) {
            return MissingEvaluator.INSTANCE;
        }
        if (readers.size() == 1) {
            IColumnValuesReader reader = readers.get(0);
            IValueGetter valueGetter = this.valueGetterFactory.createValueGetter(reader.getTypeTag());
            return new ColumnFilterValueAccessorEvaluator(reader, valueGetter);
        }
        IColumnValuesReader[] unionReaders = new IColumnValuesReader[readers.size()];
        IValueGetter[] valueGetters = new IValueGetter[readers.size()];
        for (int i = 0; i < readers.size(); ++i) {
            IColumnValuesReader reader;
            unionReaders[i] = reader = readers.get(i);
            valueGetters[i] = this.valueGetterFactory.createValueGetter(reader.getTypeTag());
        }
        return new UnionColumnFilterValueAccessorEvaluator(unionReaders, valueGetters);
    }

    public List<IColumnRangeFilterValueAccessor> getFilterAccessors() {
        return this.filterAccessors;
    }

    public List<IColumnValuesReader> getFilterColumnReaders() {
        return this.filterColumnReaders;
    }

    public static void setFilterValues(List<IColumnRangeFilterValueAccessor> filterValueAccessors, ByteBuffer pageZero, int numberOfColumns) {
        for (int i = 0; i < filterValueAccessors.size(); ++i) {
            long normalizedValue;
            ColumnRangeFilterValueAccessor accessor = (ColumnRangeFilterValueAccessor)filterValueAccessors.get(i);
            int columnIndex = accessor.getColumnIndex();
            if (columnIndex < numberOfColumns) {
                int filterOffset = pageZero.position() + columnIndex * 16;
                normalizedValue = accessor.isMin() ? pageZero.getLong(filterOffset) : pageZero.getLong(filterOffset + 8);
            } else {
                normalizedValue = accessor.isMin() ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
            accessor.setNormalizedValue(normalizedValue);
        }
    }

    private AbstractSchemaNode getNode(ARecordType path) throws HyracksDataException {
        ObjectSchemaNode dataPath = (ObjectSchemaNode)path.accept((IATypeVisitor)this.clipperVisitor, (Object)this.root);
        AbstractSchemaNode node = dataPath.accept(this.pathExtractorVisitor, null);
        if (node.getTypeTag() == ATypeTag.MISSING && this.metaRoot != null) {
            ObjectSchemaNode metaPath = (ObjectSchemaNode)path.accept((IATypeVisitor)this.clipperVisitor, (Object)this.metaRoot);
            node = metaPath.accept(this.pathExtractorVisitor, null);
        }
        return node;
    }

    private List<IColumnValuesReader> createReaders(ARecordType path) throws HyracksDataException {
        List<IColumnValuesReader> readers = Collections.emptyList();
        if (!this.cachedNodes.containsKey(path)) {
            ObjectSchemaNode dataPath = (ObjectSchemaNode)path.accept((IATypeVisitor)this.clipperVisitor, (Object)this.root);
            readers = this.pathExtractorVisitor.getOrCreateReaders(dataPath, this.filterColumnReaders);
            if (readers.isEmpty() && this.metaRoot != null) {
                ObjectSchemaNode metaPath = (ObjectSchemaNode)path.accept((IATypeVisitor)this.clipperVisitor, (Object)this.metaRoot);
                readers = this.pathExtractorVisitor.getOrCreateReaders(metaPath, this.filterColumnReaders);
            }
            if (readers.isEmpty()) {
                this.cachedNodes.put(path, (PrimitiveSchemaNode)MissingFieldSchemaNode.INSTANCE);
            }
        }
        return readers;
    }
}

