/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryHashFunctionFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class FieldNamesDictionary {
    public static final IValueReference DUMMY_FIELD_NAME;
    public static final int DUMMY_FIELD_NAME_INDEX = -1;
    private final List<IValueReference> fieldNames;
    private final Object2IntMap<String> declaredFieldNamesToIndexMap;
    private final Int2IntMap hashToFieldNameIndexMap;
    private final IBinaryHashFunction fieldNameHashFunction;
    private final AMutableString mutableString;
    private final AStringSerializerDeserializer stringSerDer;
    private final ArrayBackedValueStorage lookupStorage;

    public FieldNamesDictionary() {
        this(new ArrayList<IValueReference>(), (Object2IntMap<String>)new Object2IntOpenHashMap(), (Int2IntMap)new Int2IntOpenHashMap());
    }

    private FieldNamesDictionary(List<IValueReference> fieldNames, Object2IntMap<String> declaredFieldNamesToIndexMap, Int2IntMap hashToFieldNameIndexMap) {
        this.fieldNames = fieldNames;
        this.declaredFieldNamesToIndexMap = declaredFieldNamesToIndexMap;
        this.hashToFieldNameIndexMap = hashToFieldNameIndexMap;
        this.mutableString = new AMutableString("");
        this.stringSerDer = new AStringSerializerDeserializer(new UTF8StringWriter(), new UTF8StringReader());
        this.fieldNameHashFunction = new PointableBinaryHashFunctionFactory((IPointableFactory)UTF8StringPointable.FACTORY).createBinaryHashFunction();
        this.lookupStorage = new ArrayBackedValueStorage();
    }

    public List<IValueReference> getFieldNames() {
        return this.fieldNames;
    }

    public int getOrCreateFieldNameIndex(IValueReference fieldName) throws HyracksDataException {
        if (fieldName == DUMMY_FIELD_NAME) {
            return -1;
        }
        int hash = this.getHash(fieldName);
        if (!this.hashToFieldNameIndexMap.containsKey(hash)) {
            int index = this.addFieldName((IValueReference)this.creatFieldName(fieldName), hash);
            this.hashToFieldNameIndexMap.put(hash, index);
            return index;
        }
        return this.hashToFieldNameIndexMap.get(hash);
    }

    public int getOrCreateFieldNameIndex(String fieldName) throws HyracksDataException {
        if (!this.declaredFieldNamesToIndexMap.containsKey((Object)fieldName)) {
            ArrayBackedValueStorage serializedFieldName = this.creatFieldName(fieldName);
            int hash = this.getHash((IValueReference)serializedFieldName);
            int index = this.addFieldName((IValueReference)serializedFieldName, hash);
            this.declaredFieldNamesToIndexMap.put((Object)fieldName, index);
            return index;
        }
        return this.declaredFieldNamesToIndexMap.getInt((Object)fieldName);
    }

    public int getFieldNameIndex(String fieldName) throws HyracksDataException {
        this.lookupStorage.reset();
        this.serializeFieldName(fieldName, this.lookupStorage);
        return this.hashToFieldNameIndexMap.getOrDefault(this.getHash((IValueReference)this.lookupStorage), -1);
    }

    private ArrayBackedValueStorage creatFieldName(IValueReference fieldName) throws HyracksDataException {
        ArrayBackedValueStorage copy = new ArrayBackedValueStorage(fieldName.getLength());
        copy.append(fieldName);
        return copy;
    }

    private ArrayBackedValueStorage creatFieldName(String fieldName) throws HyracksDataException {
        ArrayBackedValueStorage serializedFieldName = new ArrayBackedValueStorage();
        this.serializeFieldName(fieldName, serializedFieldName);
        return serializedFieldName;
    }

    private void serializeFieldName(String fieldName, ArrayBackedValueStorage storage) throws HyracksDataException {
        this.mutableString.setValue(fieldName);
        this.stringSerDer.serialize((AString)this.mutableString, storage.getDataOutput());
    }

    private int getHash(IValueReference fieldName) throws HyracksDataException {
        byte[] object = fieldName.getByteArray();
        int start = fieldName.getStartOffset();
        int length = fieldName.getLength();
        return this.fieldNameHashFunction.hash(object, start, length);
    }

    private int addFieldName(IValueReference fieldName, int hash) {
        int index = this.fieldNames.size();
        this.hashToFieldNameIndexMap.put(hash, index);
        this.fieldNames.add(fieldName);
        return index;
    }

    public IValueReference getFieldName(int index) {
        if (index == -1) {
            return DUMMY_FIELD_NAME;
        }
        return this.fieldNames.get(index);
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeInt(this.fieldNames.size());
        for (IValueReference fieldName : this.fieldNames) {
            output.writeInt(fieldName.getLength());
            output.write(fieldName.getByteArray(), fieldName.getStartOffset(), fieldName.getLength());
        }
        output.writeInt(this.declaredFieldNamesToIndexMap.size());
        for (Object2IntMap.Entry declaredFieldIndex : this.declaredFieldNamesToIndexMap.object2IntEntrySet()) {
            output.writeUTF((String)declaredFieldIndex.getKey());
            output.writeInt(declaredFieldIndex.getIntValue());
        }
        for (Int2IntMap.Entry hashIndex : this.hashToFieldNameIndexMap.int2IntEntrySet()) {
            output.writeInt(hashIndex.getIntKey());
            output.writeInt(hashIndex.getIntValue());
        }
    }

    public static FieldNamesDictionary deserialize(DataInput input) throws IOException {
        int numberOfFieldNames = input.readInt();
        ArrayList<IValueReference> fieldNames = new ArrayList<IValueReference>();
        FieldNamesDictionary.deserializeFieldNames(input, fieldNames, numberOfFieldNames);
        Object2IntOpenHashMap declaredFieldNamesToIndexMap = new Object2IntOpenHashMap();
        FieldNamesDictionary.deserializeDeclaredFieldNames(input, (Object2IntMap<String>)declaredFieldNamesToIndexMap);
        Int2IntOpenHashMap hashToFieldNameIndexMap = new Int2IntOpenHashMap();
        FieldNamesDictionary.deserializeHashToFieldNameIndex(input, (Int2IntMap)hashToFieldNameIndexMap, numberOfFieldNames);
        return new FieldNamesDictionary(fieldNames, (Object2IntMap<String>)declaredFieldNamesToIndexMap, (Int2IntMap)hashToFieldNameIndexMap);
    }

    public void abort(DataInputStream input) throws IOException {
        int numberOfFieldNames = input.readInt();
        this.fieldNames.clear();
        FieldNamesDictionary.deserializeFieldNames(input, this.fieldNames, numberOfFieldNames);
        this.declaredFieldNamesToIndexMap.clear();
        FieldNamesDictionary.deserializeDeclaredFieldNames(input, this.declaredFieldNamesToIndexMap);
        this.hashToFieldNameIndexMap.clear();
        FieldNamesDictionary.deserializeHashToFieldNameIndex(input, this.hashToFieldNameIndexMap, numberOfFieldNames);
    }

    private static void deserializeFieldNames(DataInput input, List<IValueReference> fieldNames, int numberOfFieldNames) throws IOException {
        for (int i = 0; i < numberOfFieldNames; ++i) {
            int length = input.readInt();
            ArrayBackedValueStorage fieldName = new ArrayBackedValueStorage(length);
            fieldName.setSize(length);
            input.readFully(fieldName.getByteArray(), 0, length);
            fieldNames.add((IValueReference)fieldName);
        }
    }

    private static void deserializeDeclaredFieldNames(DataInput input, Object2IntMap<String> declaredFieldNamesToIndexMap) throws IOException {
        int numberOfDeclaredFieldNames = input.readInt();
        for (int i = 0; i < numberOfDeclaredFieldNames; ++i) {
            String fieldName = input.readUTF();
            int fieldNameIndex = input.readInt();
            declaredFieldNamesToIndexMap.put((Object)fieldName, fieldNameIndex);
        }
    }

    private static void deserializeHashToFieldNameIndex(DataInput input, Int2IntMap hashToFieldNameIndexMap, int numberOfFieldNames) throws IOException {
        for (int i = 0; i < numberOfFieldNames; ++i) {
            int hash = input.readInt();
            int fieldNameIndex = input.readInt();
            hashToFieldNameIndexMap.put(hash, fieldNameIndex);
        }
    }

    static {
        VoidPointable dummy = new VoidPointable();
        dummy.set(new byte[0], 0, 0);
        DUMMY_FIELD_NAME = dummy;
    }
}

