/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.flush;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.values.IColumnBatchWriter;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class BatchFinalizerVisitor
implements ISchemaNodeVisitor<Void, AbstractSchemaNestedNode> {
    private final FlushColumnMetadata columnSchemaMetadata;
    private final IColumnValuesWriter[] primaryKeyWriters;
    private final PriorityQueue<IColumnValuesWriter> orderedColumns;
    private int level;

    public BatchFinalizerVisitor(FlushColumnMetadata columnSchemaMetadata) {
        this.columnSchemaMetadata = columnSchemaMetadata;
        this.orderedColumns = new PriorityQueue<IColumnValuesWriter>(Comparator.comparingInt(x -> -x.getEstimatedSize()));
        int numberOfPrimaryKeys = columnSchemaMetadata.getNumberOfPrimaryKeys();
        this.primaryKeyWriters = new IColumnValuesWriter[numberOfPrimaryKeys];
        for (int i = 0; i < numberOfPrimaryKeys; ++i) {
            this.primaryKeyWriters[i] = columnSchemaMetadata.getWriter(i);
        }
        this.level = -1;
    }

    public int finalizeBatch(IColumnBatchWriter batchWriter, FlushColumnMetadata columnMetadata) throws HyracksDataException {
        this.orderedColumns.clear();
        columnMetadata.getRoot().accept(this, null);
        if (columnMetadata.getMetaRoot() != null) {
            columnMetadata.getMetaRoot().accept(this, null);
        }
        int allocatedSpace = batchWriter.writePrimaryKeyColumns(this.primaryKeyWriters);
        return allocatedSpace += batchWriter.writeColumns(this.orderedColumns);
    }

    @Override
    public Void visit(ObjectSchemaNode objectNode, AbstractSchemaNestedNode arg) throws HyracksDataException {
        ++this.level;
        this.columnSchemaMetadata.flushDefinitionLevels(this.level, arg, objectNode);
        List<AbstractSchemaNode> children = objectNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            children.get(i).accept(this, objectNode);
        }
        objectNode.setCounter(0);
        this.columnSchemaMetadata.clearDefinitionLevels(objectNode);
        --this.level;
        return null;
    }

    @Override
    public Void visit(AbstractCollectionSchemaNode collectionNode, AbstractSchemaNestedNode arg) throws HyracksDataException {
        ++this.level;
        this.columnSchemaMetadata.flushDefinitionLevels(this.level, arg, collectionNode);
        collectionNode.getItemNode().accept(this, collectionNode);
        collectionNode.setCounter(0);
        this.columnSchemaMetadata.clearDefinitionLevels(collectionNode);
        --this.level;
        return null;
    }

    @Override
    public Void visit(UnionSchemaNode unionNode, AbstractSchemaNestedNode arg) throws HyracksDataException {
        this.columnSchemaMetadata.flushDefinitionLevels(this.level, arg, unionNode);
        for (AbstractSchemaNode node : unionNode.getChildren().values()) {
            node.accept(this, unionNode);
        }
        unionNode.setCounter(0);
        this.columnSchemaMetadata.clearDefinitionLevels(unionNode);
        return null;
    }

    @Override
    public Void visit(PrimitiveSchemaNode primitiveNode, AbstractSchemaNestedNode arg) throws HyracksDataException {
        this.columnSchemaMetadata.flushDefinitionLevels(this.level, arg, primitiveNode);
        if (!primitiveNode.isPrimaryKey()) {
            this.orderedColumns.add(this.columnSchemaMetadata.getWriter(primitiveNode.getColumnIndex()));
        }
        primitiveNode.setCounter(0);
        return null;
    }
}

