/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.flush;

import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.AbstractListLazyVisitablePointable;
import org.apache.asterix.om.lazy.FlatLazyVisitablePointable;
import org.apache.asterix.om.lazy.ILazyVisitablePointableVisitor;
import org.apache.asterix.om.lazy.RecordLazyVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;

public class ColumnTransformer
implements ILazyVisitablePointableVisitor<AbstractSchemaNode, AbstractSchemaNode> {
    private final FlushColumnMetadata columnMetadata;
    private final VoidPointable nonTaggedValue;
    private final ObjectSchemaNode root;
    private AbstractSchemaNestedNode currentParent;
    private int primaryKeysLength;
    private int stringLengths;

    public ColumnTransformer(FlushColumnMetadata columnMetadata, ObjectSchemaNode root) {
        this.columnMetadata = columnMetadata;
        this.root = root;
        this.nonTaggedValue = new VoidPointable();
        this.stringLengths = 0;
    }

    public int getStringLengths() {
        return this.stringLengths;
    }

    public void resetStringLengths() {
        this.stringLengths = 0;
    }

    public int transform(RecordLazyVisitablePointable pointable) throws HyracksDataException {
        this.primaryKeysLength = 0;
        pointable.accept((ILazyVisitablePointableVisitor)this, (Object)this.root);
        return this.primaryKeysLength;
    }

    public int writeAntiMatter(LSMBTreeTupleReference tuple) throws HyracksDataException {
        int pkSize = 0;
        for (int i = 0; i < this.columnMetadata.getNumberOfPrimaryKeys(); ++i) {
            byte[] bytes = tuple.getFieldData(i);
            int start = tuple.getFieldStart(i);
            ATypeTag tag = ATypeTag.VALUE_TYPE_MAPPING[bytes[start]];
            this.nonTaggedValue.set(bytes, start + 1, tuple.getFieldLength(i) - 1);
            IColumnValuesWriter writer = this.columnMetadata.getWriter(i);
            writer.writeAntiMatter(tag, (IValueReference)this.nonTaggedValue);
            pkSize += writer.getEstimatedSize();
        }
        return pkSize;
    }

    public AbstractSchemaNode visit(RecordLazyVisitablePointable pointable, AbstractSchemaNode arg) throws HyracksDataException {
        this.columnMetadata.enterNode(this.currentParent, arg);
        AbstractSchemaNestedNode previousParent = this.currentParent;
        ObjectSchemaNode objectNode = (ObjectSchemaNode)arg;
        this.currentParent = objectNode;
        for (int i = 0; i < pointable.getNumberOfChildren(); ++i) {
            pointable.nextChild();
            IValueReference fieldName = pointable.getFieldName();
            ATypeTag childTypeTag = pointable.getChildTypeTag();
            if (childTypeTag == ATypeTag.MISSING) continue;
            AbstractSchemaNode childNode = objectNode.getOrCreateChild(fieldName, childTypeTag, this.columnMetadata);
            this.acceptActualNode(pointable.getChildVisitablePointable(), childNode);
        }
        if (pointable.getNumberOfChildren() == 0) {
            objectNode.setEmptyObject(this.columnMetadata);
        }
        this.columnMetadata.exitNode(arg);
        this.currentParent = previousParent;
        return null;
    }

    public AbstractSchemaNode visit(AbstractListLazyVisitablePointable pointable, AbstractSchemaNode arg) throws HyracksDataException {
        this.columnMetadata.enterNode(this.currentParent, arg);
        AbstractSchemaNestedNode previousParent = this.currentParent;
        AbstractCollectionSchemaNode collectionNode = (AbstractCollectionSchemaNode)arg;
        RunLengthIntArray defLevels = this.columnMetadata.getDefinitionLevels(collectionNode);
        int missingLevel = this.columnMetadata.getLevel();
        this.currentParent = collectionNode;
        int numberOfChildren = pointable.getNumberOfChildren();
        for (int i = 0; i < numberOfChildren; ++i) {
            pointable.nextChild();
            ATypeTag childTypeTag = pointable.getChildTypeTag();
            AbstractSchemaNode childNode = collectionNode.getOrCreateItem(childTypeTag, this.columnMetadata);
            this.acceptActualNode(pointable.getChildVisitablePointable(), childNode);
            defLevels.add(missingLevel);
        }
        collectionNode.getOrCreateItem(ATypeTag.MISSING, this.columnMetadata);
        defLevels.add(missingLevel);
        this.columnMetadata.exitCollectionNode(collectionNode, numberOfChildren);
        this.currentParent = previousParent;
        return null;
    }

    public AbstractSchemaNode visit(FlatLazyVisitablePointable pointable, AbstractSchemaNode arg) throws HyracksDataException {
        this.columnMetadata.enterNode(this.currentParent, arg);
        ATypeTag valueTypeTag = pointable.getTypeTag();
        PrimitiveSchemaNode node = (PrimitiveSchemaNode)arg;
        IColumnValuesWriter writer = this.columnMetadata.getWriter(node.getColumnIndex());
        if (valueTypeTag == ATypeTag.MISSING) {
            writer.writeLevel(this.columnMetadata.getLevel());
        } else if (valueTypeTag == ATypeTag.NULL) {
            writer.writeNull(this.columnMetadata.getLevel());
        } else if (pointable.isTagged()) {
            this.nonTaggedValue.set(pointable.getByteArray(), pointable.getStartOffset() + 1, pointable.getLength() - 1);
            writer.writeValue(pointable.getTypeTag(), (IValueReference)this.nonTaggedValue);
        } else {
            writer.writeValue(pointable.getTypeTag(), (IValueReference)pointable);
        }
        if (node.isPrimaryKey()) {
            this.primaryKeysLength += writer.getEstimatedSize();
        } else if (node.getTypeTag() == ATypeTag.STRING) {
            this.stringLengths += pointable.getLength();
        }
        this.columnMetadata.exitNode(arg);
        return null;
    }

    private void acceptActualNode(AbstractLazyVisitablePointable pointable, AbstractSchemaNode node) throws HyracksDataException {
        if (node.getTypeTag() == ATypeTag.UNION) {
            this.columnMetadata.enterNode(this.currentParent, node);
            AbstractSchemaNestedNode previousParent = this.currentParent;
            UnionSchemaNode unionNode = (UnionSchemaNode)node;
            this.currentParent = unionNode;
            ATypeTag childTypeTag = pointable.getTypeTag();
            AbstractSchemaNode actualNode = childTypeTag == ATypeTag.NULL || childTypeTag == ATypeTag.MISSING ? unionNode.getOriginalType() : unionNode.getOrCreateChild(pointable.getTypeTag(), this.columnMetadata);
            pointable.accept((ILazyVisitablePointableVisitor)this, (Object)actualNode);
            this.currentParent = previousParent;
            this.columnMetadata.exitNode(node);
        } else if (pointable.getTypeTag() == ATypeTag.NULL && node.isNested()) {
            this.columnMetadata.addNestedNull(this.currentParent, (AbstractSchemaNestedNode)node);
        } else {
            pointable.accept((ILazyVisitablePointableVisitor)this, (Object)node);
        }
    }
}

