/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.flush;

import org.apache.asterix.column.operation.lsm.flush.ColumnTransformer;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnTupleWriter;
import org.apache.asterix.om.lazy.RecordLazyVisitablePointable;
import org.apache.asterix.om.lazy.TypedRecordLazyVisitablePointable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;

public class FlushColumnTupleWithMetaWriter
extends FlushColumnTupleWriter {
    private final ColumnTransformer metaColumnTransformer;
    private final RecordLazyVisitablePointable metaPointable;

    public FlushColumnTupleWithMetaWriter(FlushColumnMetadata columnMetadata, int pageSize, int maxNumberOfTuples, double tolerance, int maxLeafNodeSize) {
        super(columnMetadata, pageSize, maxNumberOfTuples, tolerance, maxLeafNodeSize);
        this.metaColumnTransformer = new ColumnTransformer(columnMetadata, columnMetadata.getMetaRoot());
        this.metaPointable = new TypedRecordLazyVisitablePointable(columnMetadata.getMetaType());
    }

    @Override
    protected void writeMeta(LSMBTreeTupleReference btreeTuple) throws HyracksDataException {
        if (btreeTuple.isAntimatter()) {
            return;
        }
        int metaFieldId = this.columnMetadata.getMetaRecordFieldIndex();
        this.metaPointable.set(btreeTuple.getFieldData(metaFieldId), btreeTuple.getFieldStart(metaFieldId), btreeTuple.getFieldLength(metaFieldId));
        this.primaryKeysEstimatedSize = Math.max(this.metaColumnTransformer.transform(this.metaPointable), this.primaryKeysEstimatedSize);
    }
}

