/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader.value.key;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.IColumnKeyValueReader;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;

abstract class AbstractFixedLengthColumnKeyValueReader
extends AbstractValueReader
implements IColumnKeyValueReader {
    protected final IPointable value = new VoidPointable();
    private ByteBuffer buffer;
    private int startOffset;

    AbstractFixedLengthColumnKeyValueReader() {
    }

    @Override
    public void init(AbstractBytesInputStream in, int tupleCount) throws IOException {
        this.buffer = in.getBuffer();
        this.startOffset = this.buffer.position();
        this.value.set(null, 0, 0);
    }

    @Override
    public int reset(int startIndex, int skipCount) {
        this.getValue(startIndex);
        return 0;
    }

    @Override
    public IValueReference getValue(int index) {
        int valueLength = this.getValueLength();
        int offset = this.startOffset + index * valueLength;
        this.value.set(this.buffer.array(), offset, valueLength);
        return this.value;
    }

    @Override
    public void nextValue() {
        if (this.value.getByteArray() == null) {
            this.getValue(0);
            return;
        }
        int valueLength = this.getValueLength();
        int offset = this.value.getStartOffset() + valueLength;
        this.value.set(this.buffer.array(), offset, valueLength);
    }

    protected abstract int getValueLength();
}

