/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class FeedEntity {
    private static final FeedEntity FEED = new FeedEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FEED, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("FeedName")), 0, FeedEntity.feedType(), true, new int[]{0, 1}), 2, -1);
    private static final FeedEntity DB_FEED = new FeedEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FEED, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("FeedName")), 0, FeedEntity.databaseFeedType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int feedNameIndex;
    private final int adapterConfigIndex;
    private final int timestampIndex;

    private FeedEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.feedNameIndex = startIndex++;
        this.adapterConfigIndex = startIndex++;
        this.timestampIndex = startIndex++;
    }

    public static FeedEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_FEED : FEED;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int feedNameIndex() {
        return this.feedNameIndex;
    }

    public int adapterConfigIndex() {
        return this.adapterConfigIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    private static ARecordType feedType() {
        return MetadataRecordTypes.createRecordType("FeedRecordType", new String[]{"DataverseName", "FeedName", "AdapterConfiguration", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, new AUnorderedListType((IAType)MetadataRecordTypes.FEED_ADAPTER_CONFIGURATION_RECORDTYPE, null), BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseFeedType() {
        return MetadataRecordTypes.createRecordType("FeedRecordType", new String[]{"DatabaseName", "DataverseName", "FeedName", "AdapterConfiguration", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AUnorderedListType((IAType)MetadataRecordTypes.FEED_ADAPTER_CONFIGURATION_RECORDTYPE, null), BuiltinType.ASTRING}, true);
    }
}

