/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.Arrays;
import java.util.TreeSet;
import org.apache.asterix.common.api.INamespacePathResolver;
import org.apache.asterix.common.api.INamespaceResolver;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.dataflow.IDataPartitioningProvider;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.common.utils.PartitioningScheme;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.utils.DynamicDataPartitioningProvider;
import org.apache.asterix.metadata.utils.StaticDataPartitioningProvider;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksCountPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public abstract class DataPartitioningProvider
implements IDataPartitioningProvider {
    protected final ICcApplicationContext appCtx;
    protected final INamespacePathResolver namespacePathResolver;
    protected final INamespaceResolver namespaceResolver;
    protected final ClusterStateManager clusterStateManager;
    protected final int storagePartitionsCounts;

    DataPartitioningProvider(ICcApplicationContext appCtx) {
        this.appCtx = appCtx;
        this.namespacePathResolver = appCtx.getNamespacePathResolver();
        this.namespaceResolver = appCtx.getNamespaceResolver();
        this.clusterStateManager = (ClusterStateManager)appCtx.getClusterStateManager();
        this.storagePartitionsCounts = this.clusterStateManager.getStoragePartitionsCount();
    }

    public static DataPartitioningProvider create(ICcApplicationContext appCtx) {
        PartitioningScheme partitioningScheme = appCtx.getStorageProperties().getPartitioningScheme();
        switch (partitioningScheme) {
            case DYNAMIC: {
                return new DynamicDataPartitioningProvider(appCtx);
            }
            case STATIC: {
                return new StaticDataPartitioningProvider(appCtx);
            }
        }
        throw new IllegalStateException("unknown partitioning scheme: " + partitioningScheme);
    }

    public abstract PartitioningProperties getPartitioningProperties(String var1);

    public abstract PartitioningProperties getPartitioningProperties(String var1, DataverseName var2);

    public abstract PartitioningProperties getPartitioningProperties(MetadataTransactionContext var1, Dataset var2, String var3) throws AlgebricksException;

    public PartitioningProperties getPartitioningProperties(Feed feed) throws AsterixException {
        IClusterStateManager csm = this.appCtx.getClusterStateManager();
        AlgebricksAbsolutePartitionConstraint allCluster = csm.getClusterLocations();
        TreeSet<String> nodes = new TreeSet<String>(Arrays.asList(allCluster.getLocations()));
        AlgebricksAbsolutePartitionConstraint locations = new AlgebricksAbsolutePartitionConstraint(nodes.toArray(new String[0]));
        String namespacePath = this.namespacePathResolver.resolve(feed.getDatabaseName(), feed.getDataverseName());
        FileSplit[] feedLogFileSplits = FeedUtils.splitsForAdapter((String)namespacePath, (String)feed.getFeedName(), (AlgebricksPartitionConstraint)locations);
        Pair spC = StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])feedLogFileSplits);
        int[][] partitionsMap = DataPartitioningProvider.getOneToOnePartitionsMap(DataPartitioningProvider.getLocationsCount((AlgebricksPartitionConstraint)spC.second));
        return PartitioningProperties.of((IFileSplitProvider)((IFileSplitProvider)spC.first), (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)spC.second), (int[][])partitionsMap);
    }

    protected int getNumberOfPartitions(Dataset ds) {
        return MetadataIndexImmutableProperties.isMetadataDataset((int)ds.getDatasetId()) ? 1 : this.storagePartitionsCounts;
    }

    protected static int getLocationsCount(AlgebricksPartitionConstraint constraint) {
        if (constraint.getPartitionConstraintType() == AlgebricksPartitionConstraint.PartitionConstraintType.COUNT) {
            return ((AlgebricksCountPartitionConstraint)constraint).getCount();
        }
        return ((AlgebricksAbsolutePartitionConstraint)constraint).getLocations().length;
    }

    protected static int[][] getOneToOnePartitionsMap(int numPartitions) {
        int[][] map = new int[numPartitions][1];
        for (int i = 0; i < numPartitions; ++i) {
            map[i] = new int[]{i};
        }
        return map;
    }
}

