/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DataPartitioningProvider;
import org.apache.asterix.metadata.utils.SplitsAndConstraintsUtil;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class DynamicDataPartitioningProvider
extends DataPartitioningProvider {
    public DynamicDataPartitioningProvider(ICcApplicationContext appCtx) {
        super(appCtx);
    }

    @Override
    public PartitioningProperties getPartitioningProperties(String databaseName) {
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraints = SplitsAndConstraintsUtil.getDatabaseSplitProviderAndConstraints(this.appCtx.getClusterStateManager(), databaseName);
        int[][] partitionsMap = DynamicDataPartitioningProvider.getOneToOnePartitionsMap(DynamicDataPartitioningProvider.getLocationsCount((AlgebricksPartitionConstraint)splitsAndConstraints.second));
        return PartitioningProperties.of((IFileSplitProvider)((IFileSplitProvider)splitsAndConstraints.first), (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraints.second), (int[][])partitionsMap);
    }

    @Override
    public PartitioningProperties getPartitioningProperties(String databaseName, DataverseName dataverseName) {
        String namespacePath = this.namespacePathResolver.resolve(databaseName, dataverseName);
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraints = SplitsAndConstraintsUtil.getDataverseSplitProviderAndConstraints(this.appCtx.getClusterStateManager(), namespacePath);
        int[][] partitionsMap = DynamicDataPartitioningProvider.getOneToOnePartitionsMap(DynamicDataPartitioningProvider.getLocationsCount((AlgebricksPartitionConstraint)splitsAndConstraints.second));
        return PartitioningProperties.of((IFileSplitProvider)((IFileSplitProvider)splitsAndConstraints.first), (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraints.second), (int[][])partitionsMap);
    }

    @Override
    public PartitioningProperties getPartitioningProperties(MetadataTransactionContext mdTxnCtx, Dataset ds, String indexName) throws AlgebricksException {
        String namespacePath = this.namespacePathResolver.resolve(ds.getDatabaseName(), ds.getDataverseName());
        FileSplit[] splits = SplitsAndConstraintsUtil.getIndexSplits(ds, indexName, mdTxnCtx, this.appCtx.getClusterStateManager(), namespacePath);
        Pair splitsAndConstraints = StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
        int[][] partitionsMap = DynamicDataPartitioningProvider.getOneToOnePartitionsMap(DynamicDataPartitioningProvider.getLocationsCount((AlgebricksPartitionConstraint)splitsAndConstraints.second));
        return PartitioningProperties.of((IFileSplitProvider)((IFileSplitProvider)splitsAndConstraints.first), (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)splitsAndConstraints.second), (int[][])partitionsMap);
    }

    public AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        return this.clusterStateManager.getNodeSortedClusterLocations();
    }
}

