/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;
import org.apache.hyracks.data.std.primitive.VarLengthTypeTrait;

public class TypeTraitProvider
implements ITypeTraitProvider {
    private static final ITypeTraits ZERO_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(1);
    private static final ITypeTraits ONE_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(2);
    private static final ITypeTraits TWO_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(3);
    private static final ITypeTraits FOUR_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(5);
    private static final ITypeTraits EIGHT_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(9);
    private static final ITypeTraits TWELVE_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(13);
    private static final ITypeTraits SIXTEEN_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(17);
    private static final ITypeTraits SEVENTEEN_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(18);
    private static final ITypeTraits THIRTY_TWO_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(33);
    private static final ITypeTraits TWENTY_FOUR_BYTE_TYPE_TRAIT = new FixedLengthTypeTrait(25);
    private static final ITypeTraits VAR_LEN_TYPE_TRAIT = VarLengthTypeTrait.INSTANCE;
    public static final TypeTraitProvider INSTANCE = new TypeTraitProvider();

    public ITypeTraits getTypeTrait(Object typeInfo) {
        IAType type = (IAType)typeInfo;
        if (type == null) {
            return null;
        }
        switch (type.getTypeTag()) {
            case NULL: 
            case MISSING: {
                return ZERO_BYTE_TYPE_TRAIT;
            }
            case BOOLEAN: 
            case TINYINT: {
                return ONE_BYTE_TYPE_TRAIT;
            }
            case SMALLINT: {
                return TWO_BYTE_TYPE_TRAIT;
            }
            case INTEGER: 
            case FLOAT: 
            case DATE: 
            case TIME: 
            case YEARMONTHDURATION: {
                return FOUR_BYTE_TYPE_TRAIT;
            }
            case BIGINT: 
            case DOUBLE: 
            case DATETIME: 
            case DAYTIMEDURATION: {
                return EIGHT_BYTE_TYPE_TRAIT;
            }
            case DURATION: {
                return TWELVE_BYTE_TYPE_TRAIT;
            }
            case POINT: 
            case UUID: {
                return SIXTEEN_BYTE_TYPE_TRAIT;
            }
            case INTERVAL: {
                return SEVENTEEN_BYTE_TYPE_TRAIT;
            }
            case POINT3D: {
                return TWENTY_FOUR_BYTE_TYPE_TRAIT;
            }
            case LINE: {
                return THIRTY_TWO_BYTE_TYPE_TRAIT;
            }
        }
        return VAR_LEN_TYPE_TRAIT;
    }
}

