/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NotificationChannelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/notificationChannels/{notification_channel}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String notificationChannel;

    public String getProject() {
        return this.project;
    }

    public String getNotificationChannel() {
        return this.notificationChannel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private NotificationChannelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.notificationChannel = (String)Preconditions.checkNotNull((Object)builder.getNotificationChannel());
    }

    public static NotificationChannelName of(String project, String notificationChannel) {
        return NotificationChannelName.newBuilder().setProject(project).setNotificationChannel(notificationChannel).build();
    }

    public static String format(String project, String notificationChannel) {
        return NotificationChannelName.newBuilder().setProject(project).setNotificationChannel(notificationChannel).build().toString();
    }

    public static NotificationChannelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "NotificationChannelName.parse: formattedString not in valid format");
        return NotificationChannelName.of((String)matchMap.get("project"), (String)matchMap.get("notification_channel"));
    }

    public static List<NotificationChannelName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationChannelName> list = new ArrayList<NotificationChannelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationChannelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationChannelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationChannelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationChannelName notificationChannelName = this;
            synchronized (notificationChannelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"notificationChannel", (Object)this.notificationChannel);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "notification_channel", this.notificationChannel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NotificationChannelName) {
            NotificationChannelName that = (NotificationChannelName)o;
            return this.project.equals(that.project) && this.notificationChannel.equals(that.notificationChannel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.notificationChannel.hashCode();
    }

    public static class Builder {
        private String project;
        private String notificationChannel;

        public String getProject() {
            return this.project;
        }

        public String getNotificationChannel() {
            return this.notificationChannel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        private Builder() {
        }

        private Builder(NotificationChannelName notificationChannelName) {
            this.project = notificationChannelName.project;
            this.notificationChannel = notificationChannelName.notificationChannel;
        }

        public NotificationChannelName build() {
            return new NotificationChannelName(this);
        }
    }
}

