/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

abstract class BaseEntriesTable
extends BaseMetadataTable {
    BaseEntriesTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().size() < 1) {
            return TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{102}));
        }
        return schema;
    }

    static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        LoadingCache evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = (PartitionSpec)table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter((Expression)rowFilter, (PartitionSpec)transformedSpec, (boolean)caseSensitive);
        });
        CloseableIterable filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval(manifest));
        String schemaString = SchemaParser.toJson(projectedSchema);
        String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
        True filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        ResidualEvaluator residuals = ResidualEvaluator.unpartitioned((Expression)filter);
        return CloseableIterable.transform((CloseableIterable)filteredManifests, manifest -> new ManifestReadTask(table, (ManifestFile)manifest, projectedSchema, schemaString, specString, residuals));
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final Schema schema;
        private final Schema fileSchema;
        private final FileIO io;
        private final ManifestFile manifest;
        private final Map<Integer, PartitionSpec> specsById;

        ManifestReadTask(Table table, ManifestFile manifest, Schema schema, String schemaString, String specString, ResidualEvaluator residuals) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.schema = schema;
            this.io = table.io();
            this.manifest = manifest;
            this.specsById = Maps.newHashMap((Map)table.specs());
            Type fileProjection = schema.findType("data_file");
            this.fileSchema = fileProjection != null ? new Schema(fileProjection.asStructType().fields()) : new Schema(new Types.NestedField[0]);
        }

        @VisibleForTesting
        ManifestFile manifest() {
            return this.manifest;
        }

        public CloseableIterable<StructLike> rows() {
            CloseableIterable prunedRows = this.manifest.content() == ManifestContent.DATA ? CloseableIterable.transform(ManifestFiles.read(this.manifest, this.io).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file) : CloseableIterable.transform(ManifestFiles.readDeleteManifest(this.manifest, this.io, this.specsById).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file);
            Schema readSchema = ManifestEntry.wrapFileSchema(this.fileSchema.asStruct());
            StructProjection projection = StructProjection.create((Schema)readSchema, (Schema)this.schema);
            return CloseableIterable.transform((CloseableIterable)prunedRows, arg_0 -> ((StructProjection)projection).wrap(arg_0));
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of((Object)this);
        }
    }
}

