/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.BaseContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class BaseFileScanTask
extends BaseContentScanTask<FileScanTask, DataFile>
implements FileScanTask {
    private final DeleteFile[] deletes;

    public BaseFileScanTask(DataFile file, DeleteFile[] deletes, String schemaString, String specString, ResidualEvaluator residuals) {
        super(file, schemaString, specString, residuals);
        this.deletes = deletes != null ? deletes : new DeleteFile[]{};
    }

    @Override
    protected FileScanTask self() {
        return this;
    }

    @Override
    protected FileScanTask newSplitTask(FileScanTask parentTask, long offset, long length) {
        return new SplitScanTask(offset, length, parentTask);
    }

    public List<DeleteFile> deletes() {
        return ImmutableList.copyOf((Object[])this.deletes);
    }

    @VisibleForTesting
    static final class SplitScanTask
    implements FileScanTask,
    MergeableScanTask<SplitScanTask> {
        private final long len;
        private final long offset;
        private final FileScanTask fileScanTask;

        SplitScanTask(long offset, long len, FileScanTask fileScanTask) {
            this.offset = offset;
            this.len = len;
            this.fileScanTask = fileScanTask;
        }

        public DataFile file() {
            return (DataFile)this.fileScanTask.file();
        }

        public List<DeleteFile> deletes() {
            return this.fileScanTask.deletes();
        }

        public PartitionSpec spec() {
            return this.fileScanTask.spec();
        }

        public long start() {
            return this.offset;
        }

        public long length() {
            return this.len;
        }

        public Expression residual() {
            return this.fileScanTask.residual();
        }

        public Iterable<FileScanTask> split(long splitSize) {
            throw new UnsupportedOperationException("Cannot split a task which is already split");
        }

        public boolean canMerge(ScanTask other) {
            if (other instanceof SplitScanTask) {
                SplitScanTask that = (SplitScanTask)other;
                return this.file().equals(that.file()) && this.offset + this.len == that.start();
            }
            return false;
        }

        public SplitScanTask merge(ScanTask other) {
            SplitScanTask that = (SplitScanTask)other;
            return new SplitScanTask(this.offset, this.len + that.length(), this.fileScanTask);
        }
    }
}

