/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.NullOrder;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.util.Tasks;

public class BaseReplaceSortOrder
implements ReplaceSortOrder {
    private final TableOperations ops;
    private final SortOrder.Builder builder;
    private TableMetadata base;

    BaseReplaceSortOrder(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
        this.builder = SortOrder.builderFor((Schema)this.base.schema());
    }

    public SortOrder apply() {
        return this.builder.build();
    }

    public void commit() {
        Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> {
            this.base = this.ops.refresh();
            SortOrder newOrder = this.apply();
            TableMetadata updated = this.base.replaceSortOrder(newOrder);
            taskOps.commit(this.base, updated);
        });
    }

    public ReplaceSortOrder asc(Term term, NullOrder nullOrder) {
        this.builder.asc(term, nullOrder);
        return this;
    }

    public ReplaceSortOrder desc(Term term, NullOrder nullOrder) {
        this.builder.desc(term, nullOrder);
        return this;
    }
}

