/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.actions.BinPackStrategy;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.util.SortOrderUtil;

public abstract class SortStrategy
extends BinPackStrategy {
    private SortOrder sortOrder;

    public SortStrategy sortOrder(SortOrder order) {
        Preconditions.checkArgument((!order.isUnsorted() ? 1 : 0) != 0, (Object)"Cannot set strategy sort order: unsorted");
        this.sortOrder = SortOrderUtil.buildSortOrder(this.table(), order);
        return this;
    }

    protected SortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    public String name() {
        return "SORT";
    }

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.builder().addAll(super.validOptions()).build();
    }

    @Override
    public RewriteStrategy options(Map<String, String> options) {
        super.options(options);
        if (this.sortOrder == null) {
            this.sortOrder = this.table().sortOrder();
        }
        this.validateOptions();
        return this;
    }

    protected void validateOptions() {
        Preconditions.checkArgument((!this.sortOrder.isUnsorted() ? 1 : 0) != 0, (String)"Can't use %s when there is no sort order, either define table %s's sort order or set sortorder in the action", (Object)this.name(), (Object)this.table().name());
        SortOrder.checkCompatibility((SortOrder)this.sortOrder, (Schema)this.table().schema());
    }
}

