/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.base;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.translator.ResultMetadata;
import org.apache.asterix.translator.SessionConfig;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.compiler.api.ICompiler;
import org.apache.hyracks.algebricks.compiler.api.ICompilerFactory;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.rewriter.base.IRuleSetKind;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.IResultSetReader;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.nc.resources.memory.FrameManager;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleInputStream;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class AnalysisUtil {
    private static final List<FunctionIdentifier> fieldAccessFunctions = Arrays.asList(BuiltinFunctions.GET_DATA, BuiltinFunctions.GET_HANDLE, BuiltinFunctions.TYPE_OF);

    public static final ILogicalOperator firstChildOfType(AbstractLogicalOperator op, LogicalOperatorTag opType) {
        List ins = op.getInputs();
        if (ins == null || ins.isEmpty()) {
            return null;
        }
        Mutable opRef2 = (Mutable)ins.get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() == opType) {
            return op2;
        }
        return null;
    }

    public static int numberOfVarsInExpr(ILogicalExpression e) {
        switch (e.getExpressionTag()) {
            case CONSTANT: {
                return 0;
            }
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)e;
                int s = 0;
                for (Mutable arg : f.getArguments()) {
                    s += AnalysisUtil.numberOfVarsInExpr((ILogicalExpression)arg.getValue());
                }
                return s;
            }
            case VARIABLE: {
                return 1;
            }
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    public static boolean isRunnableFieldAccessFunction(FunctionIdentifier fid) {
        return fieldAccessFunctions.contains(fid);
    }

    public static boolean isRunnableAccessToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && AnalysisUtil.isRunnableFieldAccessFunction(fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier());
    }

    public static boolean isAccessByNameToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()).equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME);
    }

    public static boolean isAccessToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && ((fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()).equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX) || fid.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME) || fid.equals((Object)BuiltinFunctions.FIELD_ACCESS_NESTED));
    }

    public static Triple<DataverseName, String, String> getExternalDatasetInfo(UnnestMapOperator op) throws AlgebricksException {
        AbstractFunctionCallExpression unnestExpr = (AbstractFunctionCallExpression)op.getExpressionRef().getValue();
        String databaseName = AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)unnestExpr.getArguments().get(0)));
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)unnestExpr.getArguments().get(1))));
        String datasetName = AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)unnestExpr.getArguments().get(2)));
        return new Triple((Object)dataverseName, (Object)datasetName, (Object)databaseName);
    }

    public static boolean hasFunctionWithProperty(WindowOperator winOp, BuiltinFunctions.WindowFunctionProperty property) throws CompilationException {
        for (Mutable exprRef : winOp.getExpressions()) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, winOp.getSourceLocation(), new Serializable[]{expr.getExpressionTag()});
            }
            AbstractFunctionCallExpression callExpr = (AbstractFunctionCallExpression)expr;
            if (!BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)callExpr.getFunctionIdentifier(), (BuiltinFunctions.BuiltinFunctionProperty)property)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWindowFrameBoundaryMonotonic(List<Mutable<ILogicalExpression>> frameBoundaryExprList, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> frameValueExprList) {
        if (frameValueExprList.size() != 1) {
            return false;
        }
        ILogicalExpression frameValueExpr = (ILogicalExpression)((Mutable)frameValueExprList.get((int)0).second).getValue();
        if (frameValueExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        if (frameBoundaryExprList.size() != 1) {
            return false;
        }
        ILogicalExpression frameStartExpr = (ILogicalExpression)frameBoundaryExprList.get(0).getValue();
        switch (frameStartExpr.getExpressionTag()) {
            case CONSTANT: {
                return true;
            }
            case VARIABLE: {
                return frameStartExpr.equals(frameValueExpr);
            }
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression frameStartCallExpr = (AbstractFunctionCallExpression)frameStartExpr;
                FunctionIdentifier fi = frameStartCallExpr.getFunctionIdentifier();
                return (BuiltinFunctions.NUMERIC_ADD.equals((Object)fi) || BuiltinFunctions.NUMERIC_SUBTRACT.equals((Object)fi)) && ((ILogicalExpression)((Mutable)frameStartCallExpr.getArguments().get(0)).getValue()).equals(frameValueExpr) && ((ILogicalExpression)((Mutable)frameStartCallExpr.getArguments().get(1)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT;
            }
        }
        throw new IllegalStateException(String.valueOf(frameStartExpr.getExpressionTag()));
    }

    public static boolean isTrivialAggregateSubplan(ILogicalPlan subplan) {
        if (subplan.getRoots().isEmpty()) {
            return false;
        }
        for (Mutable rootOpRef : subplan.getRoots()) {
            ILogicalOperator rootOp = (ILogicalOperator)rootOpRef.getValue();
            if (rootOp.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
                return false;
            }
            if (AnalysisUtil.firstChildOfType((AbstractLogicalOperator)rootOp, LogicalOperatorTag.NESTEDTUPLESOURCE) != null) continue;
            return false;
        }
        return true;
    }

    public static List<List<IAObject>> runQuery(Mutable<ILogicalOperator> topOp, List<LogicalVariable> resultVars, IOptimizationContext queryOptCtx, IRuleSetKind ruleSetKind) throws AlgebricksException {
        MetadataProvider metadataProvider = (MetadataProvider)queryOptCtx.getMetadataProvider();
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        TxnId mainTxnId = metadataProvider.getTxnId();
        try {
            TxnId newTxnId = metadataProvider.getTxnIdFactory().create();
            metadataProvider.setTxnId(newTxnId);
            IVariableTypeEnvironment topOpTypeEnv = queryOptCtx.getOutputTypeEnvironment((ILogicalOperator)topOp.getValue());
            SerializerDeserializerProvider serdeProvider = SerializerDeserializerProvider.INSTANCE;
            int nFields = resultVars.size();
            ArrayList<MutableObject> resultExprList = new ArrayList<MutableObject>(nFields);
            ArrayList<ISerializerDeserializer> resultSerdeList = new ArrayList<ISerializerDeserializer>(nFields);
            for (LogicalVariable var : resultVars) {
                Object varType = topOpTypeEnv.getVarType(var);
                if (varType == null) {
                    throw new IllegalArgumentException("Cannot determine type of " + var);
                }
                resultSerdeList.add(serdeProvider.getSerializerDeserializer(varType));
                resultExprList.add(new MutableObject((Object)new VariableReferenceExpression(var)));
            }
            ResultMetadata resultMetadata = new ResultMetadata(SessionConfig.OutputFormat.ADM);
            ResultSetId resultSetId = new ResultSetId((long)metadataProvider.getResultSetIdCounter().getAndInc());
            ResultSetSinkId rssId = new ResultSetSinkId(resultSetId);
            ResultSetDataSink sink = new ResultSetDataSink(rssId, null);
            DistributeResultOperator resultOp = new DistributeResultOperator(resultExprList, (IDataSink)sink, (IResultMetadata)resultMetadata);
            resultOp.getInputs().add(topOp);
            queryOptCtx.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)resultOp);
            MutableObject newResultOpRef = new MutableObject((Object)resultOp);
            ICompilerFactory compilerFactory = (ICompilerFactory)queryOptCtx.getCompilerFactory();
            ICompiler compiler = compilerFactory.createCompiler((ILogicalPlan)new ALogicalPlanImpl((Mutable)newResultOpRef), queryOptCtx, ruleSetKind);
            compiler.optimize();
            JobSpecification jobSpec = compiler.createJob((Object)appCtx, (IJobletEventListenerFactory)new JobEventListenerFactory(newTxnId, false));
            JobId jobId = JobUtils.runJob((IHyracksClientConnection)appCtx.getHcc(), (JobSpecification)jobSpec, (boolean)true);
            IResultSetReader resultSetReader = appCtx.getResultSet().createReader(jobId, resultSetId);
            FrameManager frameManager = new FrameManager(queryOptCtx.getPhysicalOptimizationConfig().getFrameSize());
            VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)frameManager);
            FrameTupleAccessor fta = new FrameTupleAccessor(null);
            ByteArrayAccessibleInputStream bais = new ByteArrayAccessibleInputStream(frame.getBuffer().array(), 0, 0);
            DataInputStream dis = new DataInputStream((InputStream)bais);
            ArrayList<List<IAObject>> result = new ArrayList<List<IAObject>>();
            while (resultSetReader.read((IFrame)frame) > 0) {
                ByteBuffer buffer = frame.getBuffer();
                fta.reset(buffer);
                int nTuples = fta.getTupleCount();
                for (int tupleIdx = 0; tupleIdx < nTuples; ++tupleIdx) {
                    int tupleStart = fta.getTupleStartOffset(tupleIdx);
                    int tupleEnd = fta.getTupleEndOffset(tupleIdx);
                    bais.setContent(buffer.array(), tupleStart, tupleEnd - tupleStart);
                    ArrayList<IAObject> values = new ArrayList<IAObject>(nFields);
                    for (int fieldIdx = 0; fieldIdx < nFields; ++fieldIdx) {
                        IAObject value = (IAObject)((ISerializerDeserializer)resultSerdeList.get(fieldIdx)).deserialize((DataInput)dis);
                        values.add(value);
                    }
                    result.add(values);
                }
            }
            ArrayList<List<IAObject>> arrayList = result;
            return arrayList;
        }
        catch (AlgebricksException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        finally {
            metadataProvider.setTxnId(mainTxnId);
        }
    }
}

