/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.column.validation.ColumnSupportedTypesValidator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class EnsureColumnarSupportedTypesRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT || context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        InsertDeleteUpsertOperator modOp = (InsertDeleteUpsertOperator)op;
        context.addToDontApplySet((IAlgebraicRewriteRule)this, op);
        InsertDeleteUpsertOperator.Kind operation = modOp.getOperation();
        if (operation != InsertDeleteUpsertOperator.Kind.INSERT && operation != InsertDeleteUpsertOperator.Kind.UPSERT) {
            return false;
        }
        DatasetConfig.DatasetFormat format = this.getFormat(modOp, context);
        if (format != DatasetConfig.DatasetFormat.COLUMN) {
            return false;
        }
        IVariableTypeEnvironment typeEnv = context.getOutputTypeEnvironment((ILogicalOperator)modOp);
        IAType type = (IAType)typeEnv.getType((ILogicalExpression)modOp.getPayloadExpression().getValue());
        SourceLocation srcLoc = ((ILogicalExpression)modOp.getPayloadExpression().getValue()).getSourceLocation();
        ColumnSupportedTypesValidator.validate((DatasetConfig.DatasetFormat)format, (IAType)type, (SourceLocation)srcLoc);
        return false;
    }

    private DatasetConfig.DatasetFormat getFormat(InsertDeleteUpsertOperator modOp, IOptimizationContext context) throws AlgebricksException {
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        DataSource dataSource = (DataSource)modOp.getDataSource();
        if (dataSource == null) {
            return null;
        }
        DataverseName dataverse = dataSource.getId().getDataverseName();
        String datasetName = dataSource.getId().getDatasourceName();
        String database = dataSource.getId().getDatabaseName();
        Dataset dataset = metadataProvider.findDataset(database, dataverse, datasetName);
        if (dataset != null) {
            return dataset.getDatasetFormatInfo().getFormat();
        }
        return null;
    }
}

