/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.visitor.ConstantFoldingVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class NormalizeWritingPathRule
implements IAlgebraicRewriteRule {
    private final ConstantFoldingVisitor cfv;
    private boolean checked = false;

    public NormalizeWritingPathRule(ICcApplicationContext appCtx) {
        this.cfv = new ConstantFoldingVisitor(appCtx);
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.checked) {
            return false;
        }
        this.checked = true;
        ILogicalOperator distributeResultOp = (ILogicalOperator)opRef.getValue();
        ILogicalOperator op = (ILogicalOperator)((Mutable)distributeResultOp.getInputs().get(0)).getValue();
        if (distributeResultOp.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT || op.getOperatorTag() != LogicalOperatorTag.WRITE) {
            return false;
        }
        this.cfv.reset(context);
        WriteOperator writeOp = (WriteOperator)op;
        Mutable pathExprRef = writeOp.getPathExpression();
        IVariableTypeEnvironment typeEnv = context.getOutputTypeEnvironment(distributeResultOp);
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        IFunctionInfo info = metadataProvider.lookupFunction(BuiltinFunctions.TO_STRING);
        boolean changed = this.normalize((Mutable<ILogicalExpression>)pathExprRef, info, typeEnv);
        context.computeAndSetTypeEnvironmentForOperator(distributeResultOp);
        return changed;
    }

    private boolean normalize(Mutable<ILogicalExpression> exprRef, IFunctionInfo toStringInfo, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        ILogicalExpression expression = (ILogicalExpression)exprRef.getValue();
        if (expression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return this.wrapInToStringIfNeeded(exprRef, toStringInfo, typeEnv);
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        if (!BuiltinFunctions.STRING_CONCAT.equals((Object)funcExpr.getFunctionIdentifier())) {
            return this.wrapInToStringIfNeeded(exprRef, toStringInfo, typeEnv);
        }
        Mutable concatArgRef = (Mutable)funcExpr.getArguments().get(0);
        ILogicalExpression concatArg = (ILogicalExpression)concatArgRef.getValue();
        if (concatArg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return this.wrapInToStringIfNeeded((Mutable<ILogicalExpression>)concatArgRef, toStringInfo, typeEnv);
        }
        AbstractFunctionCallExpression listConst = (AbstractFunctionCallExpression)concatArg;
        List args = listConst.getArguments();
        ArrayList<Mutable<ILogicalExpression>> newArgs = new ArrayList<Mutable<ILogicalExpression>>();
        StringBuilder builder = new StringBuilder();
        int foldedConst = 0;
        boolean changed = false;
        SourceLocation constSrcLocation = null;
        for (int i = 0; i < args.size(); ++i) {
            Mutable argRef = (Mutable)args.get(i);
            changed |= this.wrapInToStringIfNeeded((Mutable<ILogicalExpression>)argRef, toStringInfo, typeEnv);
            ILogicalExpression argExpr = (ILogicalExpression)argRef.getValue();
            ATypeTag typeTag = this.evaluateAndAppendString(argExpr, builder, typeEnv);
            if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
                throw new CompilationException(ErrorCode.NON_STRING_WRITE_PATH, argExpr.getSourceLocation(), new Serializable[]{typeTag});
            }
            if (typeTag == ATypeTag.STRING) {
                if (foldedConst++ != 0) continue;
                constSrcLocation = argExpr.getSourceLocation();
                continue;
            }
            changed |= this.addFoldedArgument(foldedConst, builder, args, i, newArgs, constSrcLocation);
            newArgs.add((Mutable<ILogicalExpression>)argRef);
        }
        args.clear();
        args.addAll(newArgs);
        return changed |= this.addFoldedArgument(foldedConst, builder, args, args.size(), newArgs, constSrcLocation);
    }

    private boolean addFoldedArgument(int foldedConst, StringBuilder builder, List<Mutable<ILogicalExpression>> args, int i, List<Mutable<ILogicalExpression>> newArgs, SourceLocation constSrcLocation) {
        boolean changed = false;
        if (foldedConst == 1) {
            newArgs.add(args.get(i - 1));
            builder.setLength(0);
        } else if (foldedConst > 1) {
            ConstantExpression contExpr = ConstantExpressionUtil.create((String)builder.toString(), (SourceLocation)constSrcLocation);
            newArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)contExpr));
            builder.setLength(0);
            changed = true;
        }
        return changed;
    }

    private ATypeTag evaluateAndAppendString(ILogicalExpression argExpr, StringBuilder builder, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        Pair pair = (Pair)argExpr.accept((ILogicalExpressionVisitor)this.cfv, null);
        ILogicalExpression foldedExpr = (ILogicalExpression)pair.getSecond();
        if (foldedExpr == null || foldedExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return ATypeTag.ANY;
        }
        ATypeTag typeTag = ((IAType)typeEnv.getType(foldedExpr)).getTypeTag();
        if (typeTag == ATypeTag.STRING) {
            builder.append(ConstantExpressionUtil.getStringConstant((ILogicalExpression)foldedExpr));
        }
        return typeTag;
    }

    private boolean wrapInToStringIfNeeded(Mutable<ILogicalExpression> exprRef, IFunctionInfo fInfo, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        IAType type = (IAType)typeEnv.getType(expr);
        if (this.isString(type) || this.isNullOrMissing(type)) {
            return false;
        }
        ScalarFunctionCallExpression toString = new ScalarFunctionCallExpression(fInfo, new Mutable[]{new MutableObject((Object)expr)});
        exprRef.setValue((Object)toString);
        return true;
    }

    private boolean isNullOrMissing(IAType type) {
        ATypeTag typeTag = type.getTypeTag();
        return typeTag == ATypeTag.NULL || typeTag == ATypeTag.MISSING;
    }

    private boolean isString(IAType type) {
        IAType actualType = type;
        if (actualType.getTypeTag() == ATypeTag.UNION) {
            actualType = ((AUnionType)actualType).getActualType();
        }
        return actualType.getTypeTag() == ATypeTag.STRING;
    }
}

