/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class IntroduceLSMComponentFilterRule
implements IAlgebraicRewriteRule {
    protected IVariableTypeEnvironment typeEnvironment = null;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (!this.checkIfRuleIsApplicable(opRef, context)) {
            return false;
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        Dataset dataset = this.getDataset(op, context);
        Integer filterSourceIndicator = null;
        List filterFieldName = null;
        ARecordType itemType = null;
        MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
        if (dataset != null && dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            IAType filterSourceType;
            filterSourceIndicator = DatasetUtil.getFilterSourceIndicator((Dataset)dataset);
            filterFieldName = DatasetUtil.getFilterField((Dataset)dataset);
            IAType iAType = filterSourceType = filterSourceIndicator == null || filterSourceIndicator == 0 ? mp.findType(dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName()) : mp.findType(dataset.getMetaItemTypeDatabaseName(), dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
            if (filterSourceType.getTypeTag() == ATypeTag.OBJECT) {
                itemType = (ARecordType)filterSourceType;
            }
        }
        if (filterFieldName == null || itemType == null) {
            return false;
        }
        IAType filterType = itemType.getSubFieldType(filterFieldName);
        this.typeEnvironment = context.getOutputTypeEnvironment((ILogicalOperator)op);
        ILogicalExpression condExpr = (ILogicalExpression)((SelectOperator)op).getCondition().getValue();
        AccessMethodAnalysisContext analysisCtx = this.analyzeCondition(condExpr, context, this.typeEnvironment);
        ArrayList<IOptimizableFuncExpr> optFuncExprs = new ArrayList<IOptimizableFuncExpr>();
        if (!analysisCtx.getMatchedFuncExprs().isEmpty()) {
            List datasetIndexes = mp.getDatasetIndexes(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName());
            for (int i = 0; i < analysisCtx.getMatchedFuncExprs().size(); ++i) {
                IOptimizableFuncExpr optFuncExpr = analysisCtx.getMatchedFuncExpr(i);
                boolean found = this.findMatchedExprFieldName(optFuncExpr, op, dataset, itemType, datasetIndexes, context, filterSourceIndicator);
                if (!found || !optFuncExpr.getFieldName(0).equals(filterFieldName) || optFuncExpr.getFieldSource(0) != filterSourceIndicator.intValue()) continue;
                optFuncExprs.add(optFuncExpr);
            }
        }
        if (optFuncExprs.isEmpty()) {
            this.assignFilterFromSecondaryUnnestMap(op, dataset, context, filterType);
        } else {
            this.assignFilterFromQuery(optFuncExprs, op, dataset, context, filterType);
        }
        OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        return true;
    }

    private AssignOperator createAssignOperator(List<IOptimizableFuncExpr> optFuncExprs, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, IOptimizationContext context, SourceLocation sourceLoc) {
        ArrayList<LogicalVariable> assignKeyVarList = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> assignKeyExprList = new ArrayList<MutableObject>();
        for (IOptimizableFuncExpr optFuncExpr : optFuncExprs) {
            AlgebricksBuiltinFunctions.ComparisonKind ck = AlgebricksBuiltinFunctions.getComparisonType((FunctionIdentifier)optFuncExpr.getFuncExpr().getFunctionIdentifier());
            ILogicalExpression searchKeyExpr = optFuncExpr.getConstantExpr(0);
            LogicalVariable var = context.newVar();
            assignKeyExprList.add(new MutableObject((Object)searchKeyExpr));
            assignKeyVarList.add(var);
            if (ck == AlgebricksBuiltinFunctions.ComparisonKind.GE || ck == AlgebricksBuiltinFunctions.ComparisonKind.GT) {
                minFilterVars.add(var);
                continue;
            }
            if (ck == AlgebricksBuiltinFunctions.ComparisonKind.LE || ck == AlgebricksBuiltinFunctions.ComparisonKind.LT) {
                maxFilterVars.add(var);
                continue;
            }
            if (ck != AlgebricksBuiltinFunctions.ComparisonKind.EQ) continue;
            minFilterVars.add(var);
            maxFilterVars.add(var);
        }
        AssignOperator assignOp = new AssignOperator(assignKeyVarList, assignKeyExprList);
        assignOp.setSourceLocation(sourceLoc);
        return assignOp;
    }

    private void assignFilterFromQuery(List<IOptimizableFuncExpr> optFuncExprs, AbstractLogicalOperator op, Dataset dataset, IOptimizationContext context, IAType filterType) throws AlgebricksException {
        ArrayList<UnnestMapOperator> primaryUnnestMapOps = new ArrayList<UnnestMapOperator>();
        boolean hasSecondaryIndexMap = false;
        LinkedList queue = new LinkedList(op.getInputs());
        while (!queue.isEmpty()) {
            UnnestMapOperator unnestMapOp;
            ILogicalExpression unnestExpr;
            AbstractLogicalOperator descendantOp = (AbstractLogicalOperator)((Mutable)queue.poll()).getValue();
            if (descendantOp == null) continue;
            if (descendantOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
                DataSourceScanOperator dataSourceScanOp = (DataSourceScanOperator)descendantOp;
                DataSource ds = (DataSource)dataSourceScanOp.getDataSource();
                if (dataset.getDatasetName().compareTo(((DatasetDataSource)ds).getDataset().getDatasetName()) == 0) {
                    ArrayList<LogicalVariable> minFilterVars = new ArrayList<LogicalVariable>();
                    ArrayList<LogicalVariable> maxFilterVars = new ArrayList<LogicalVariable>();
                    AssignOperator assignOp = this.createAssignOperator(optFuncExprs, minFilterVars, maxFilterVars, context, dataSourceScanOp.getSourceLocation());
                    dataSourceScanOp.setMinFilterVars(minFilterVars);
                    dataSourceScanOp.setMaxFilterVars(maxFilterVars);
                    ArrayList<MutableObject> additionalFilteringExpressions = new ArrayList<MutableObject>();
                    for (LogicalVariable var : assignOp.getVariables()) {
                        VariableReferenceExpression varRef = new VariableReferenceExpression(var);
                        varRef.setSourceLocation(assignOp.getSourceLocation());
                        additionalFilteringExpressions.add(new MutableObject((Object)varRef));
                    }
                    dataSourceScanOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
                    assignOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)dataSourceScanOp.getInputs().get(0)).getValue())));
                    ((Mutable)dataSourceScanOp.getInputs().get(0)).setValue((Object)assignOp);
                }
            } else if (descendantOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP && (unnestExpr = (ILogicalExpression)(unnestMapOp = (UnnestMapOperator)descendantOp).getExpressionRef().getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
                FunctionIdentifier fid = f.getFunctionIdentifier();
                if (!fid.equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, unnestMapOp.getSourceLocation(), new Serializable[]{"Illegal function found, expected an index-search."});
                }
                AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
                jobGenParams.readFromFuncArgs(f.getArguments());
                if (dataset.getDatasetName().compareTo(jobGenParams.datasetName) == 0) {
                    ArrayList<LogicalVariable> minFilterVars = new ArrayList<LogicalVariable>();
                    ArrayList<LogicalVariable> maxFilterVars = new ArrayList<LogicalVariable>();
                    AssignOperator assignOp = this.createAssignOperator(optFuncExprs, minFilterVars, maxFilterVars, context, unnestMapOp.getSourceLocation());
                    unnestMapOp.setMinFilterVars(minFilterVars);
                    unnestMapOp.setMaxFilterVars(maxFilterVars);
                    ArrayList<MutableObject> additionalFilteringExpressions = new ArrayList<MutableObject>();
                    for (LogicalVariable var : assignOp.getVariables()) {
                        VariableReferenceExpression varRef = new VariableReferenceExpression(var);
                        varRef.setSourceLocation(assignOp.getSourceLocation());
                        additionalFilteringExpressions.add(new MutableObject((Object)varRef));
                    }
                    unnestMapOp.setAdditionalFilteringExpressions(additionalFilteringExpressions);
                    assignOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)unnestMapOp.getInputs().get(0)).getValue())));
                    ((Mutable)unnestMapOp.getInputs().get(0)).setValue((Object)assignOp);
                    if (jobGenParams.isPrimaryIndex) {
                        primaryUnnestMapOps.add(unnestMapOp);
                    } else {
                        hasSecondaryIndexMap = true;
                    }
                }
            }
            queue.addAll(descendantOp.getInputs());
        }
        if (hasSecondaryIndexMap && !primaryUnnestMapOps.isEmpty()) {
            this.propagateFilterToPrimaryIndex(primaryUnnestMapOps, filterType, context, false);
        }
    }

    private void propagateFilterToPrimaryIndex(List<UnnestMapOperator> primaryUnnestMapOps, IAType filterType, IOptimizationContext context, boolean isIndexOnlyPlan) throws AlgebricksException {
        block5: for (UnnestMapOperator primaryOp : primaryUnnestMapOps) {
            Mutable assignOrOrderOrIntersect;
            Mutable intersectOrSortOrSplit = assignOrOrderOrIntersect = (Mutable)primaryOp.getInputs().get(0);
            if (((ILogicalOperator)assignOrOrderOrIntersect.getValue()).getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                intersectOrSortOrSplit = (Mutable)((ILogicalOperator)assignOrOrderOrIntersect.getValue()).getInputs().get(0);
            }
            switch (((ILogicalOperator)intersectOrSortOrSplit.getValue()).getOperatorTag()) {
                case INTERSECT: {
                    IntersectOperator intersect = (IntersectOperator)intersectOrSortOrSplit.getValue();
                    ArrayList<List<LogicalVariable>> filterVars = new ArrayList<List<LogicalVariable>>(intersect.getInputs().size());
                    for (Mutable mutableOp : intersect.getInputs()) {
                        ILogicalOperator child = (ILogicalOperator)mutableOp.getValue();
                        while (!child.getOperatorTag().equals((Object)LogicalOperatorTag.UNNEST_MAP)) {
                            child = (ILogicalOperator)((Mutable)child.getInputs().get(0)).getValue();
                        }
                        UnnestMapOperator unnestMap = (UnnestMapOperator)child;
                        this.propagateFilterInSecondaryUnnsetMap(unnestMap, filterType, context);
                        List<LogicalVariable> extraVars = Arrays.asList(unnestMap.getPropagateIndexMinFilterVar(), unnestMap.getPropagateIndexMaxFilterVar());
                        filterVars.add(extraVars);
                    }
                    if (filterVars.isEmpty()) continue block5;
                    int outputFilterVarsCount = ((List)filterVars.get(0)).size();
                    ArrayList outputFilterVars = new ArrayList(outputFilterVarsCount);
                    for (int i = 0; i < outputFilterVarsCount; ++i) {
                        outputFilterVars.add(context.newVar());
                    }
                    IntersectOperator intersectWithFilter = this.createIntersectWithFilter(outputFilterVars, filterVars, intersect);
                    intersectOrSortOrSplit.setValue((Object)intersectWithFilter);
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)intersectWithFilter);
                    this.setPrimaryFilterVar(primaryOp, (LogicalVariable)outputFilterVars.get(0), (LogicalVariable)outputFilterVars.get(1), context);
                    break;
                }
                case SPLIT: {
                    if (!isIndexOnlyPlan) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{((ILogicalOperator)intersectOrSortOrSplit.getValue()).getOperatorTag().toString()});
                    }
                    SplitOperator split = (SplitOperator)intersectOrSortOrSplit.getValue();
                    for (Mutable childOp : split.getInputs()) {
                        ILogicalOperator child = (ILogicalOperator)childOp.getValue();
                        while (!child.getOperatorTag().equals((Object)LogicalOperatorTag.UNNEST_MAP)) {
                            child = (ILogicalOperator)((Mutable)child.getInputs().get(0)).getValue();
                        }
                        UnnestMapOperator unnestMap = (UnnestMapOperator)child;
                        this.propagateFilterInSecondaryUnnsetMap(unnestMap, filterType, context);
                        this.setPrimaryFilterVar(primaryOp, unnestMap.getPropagateIndexMinFilterVar(), unnestMap.getPropagateIndexMaxFilterVar(), context);
                    }
                    continue block5;
                }
                case ORDER: 
                case DISTINCT: {
                    UnnestMapOperator secondaryMap;
                    ILogicalOperator child = (ILogicalOperator)((Mutable)((ILogicalOperator)intersectOrSortOrSplit.getValue()).getInputs().get(0)).getValue();
                    if (!child.getOperatorTag().equals((Object)LogicalOperatorTag.UNNEST_MAP) || (secondaryMap = (UnnestMapOperator)child).propagateIndexFilter()) continue block5;
                    this.propagateFilterInSecondaryUnnsetMap(secondaryMap, filterType, context);
                    this.setPrimaryFilterVar(primaryOp, secondaryMap.getPropagateIndexMinFilterVar(), secondaryMap.getPropagateIndexMaxFilterVar(), context);
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{((ILogicalOperator)intersectOrSortOrSplit.getValue()).getOperatorTag().toString()});
                }
            }
        }
    }

    private IntersectOperator createIntersectWithFilter(List<LogicalVariable> outputFilterVars, List<List<LogicalVariable>> filterVars, IntersectOperator intersect) throws AlgebricksException {
        int nInput = intersect.getNumInput();
        ArrayList inputCompareVars = new ArrayList(nInput);
        for (int i = 0; i < nInput; ++i) {
            inputCompareVars.add(new ArrayList(intersect.getInputCompareVariables(i)));
        }
        IntersectOperator intersectWithFilter = new IntersectOperator(intersect.getOutputCompareVariables(), outputFilterVars, inputCompareVars, filterVars, intersect.getPartitionsMap());
        intersectWithFilter.setSourceLocation(intersect.getSourceLocation());
        intersectWithFilter.getInputs().addAll(intersect.getInputs());
        return intersectWithFilter;
    }

    private void propagateFilterInSecondaryUnnsetMap(UnnestMapOperator secondaryUnnest, IAType filterType, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable minIndexFilterVar = context.newVar();
        LogicalVariable maxIndexFilterVar = context.newVar();
        secondaryUnnest.markPropagageIndexFilter();
        secondaryUnnest.getVariables().add(minIndexFilterVar);
        secondaryUnnest.getVariableTypes().add(filterType);
        secondaryUnnest.getVariables().add(maxIndexFilterVar);
        secondaryUnnest.getVariableTypes().add(filterType);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)secondaryUnnest);
    }

    private void setPrimaryFilterVar(UnnestMapOperator primaryOp, LogicalVariable minFilterVar, LogicalVariable maxFilterVar, IOptimizationContext context) throws AlgebricksException {
        primaryOp.setMinFilterVars(Collections.singletonList(minFilterVar));
        primaryOp.setMaxFilterVars(Collections.singletonList(maxFilterVar));
        VariableReferenceExpression minFilterVarRef = new VariableReferenceExpression(minFilterVar);
        minFilterVarRef.setSourceLocation(primaryOp.getSourceLocation());
        VariableReferenceExpression maxFilterVarRef = new VariableReferenceExpression(maxFilterVar);
        maxFilterVarRef.setSourceLocation(primaryOp.getSourceLocation());
        List<Mutable> indexFilterExpression = Arrays.asList(new MutableObject((Object)minFilterVarRef), new MutableObject((Object)maxFilterVarRef));
        primaryOp.setAdditionalFilteringExpressions(indexFilterExpression);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)primaryOp);
    }

    private void assignFilterFromSecondaryUnnestMap(AbstractLogicalOperator op, Dataset dataset, IOptimizationContext context, IAType filterType) throws AlgebricksException {
        ArrayList<UnnestMapOperator> primaryUnnestMapOps = new ArrayList<UnnestMapOperator>();
        boolean hasSecondaryIndexMap = false;
        boolean isIndexOnlyPlan = false;
        LinkedList queue = new LinkedList(op.getInputs());
        while (!queue.isEmpty()) {
            UnnestMapOperator unnestMapOp;
            ILogicalExpression unnestExpr;
            ILogicalOperator descendantOp = (ILogicalOperator)((Mutable)queue.poll()).getValue();
            if (descendantOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP && (unnestExpr = (ILogicalExpression)(unnestMapOp = (UnnestMapOperator)descendantOp).getExpressionRef().getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
                FunctionIdentifier fid = f.getFunctionIdentifier();
                if (!fid.equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, f.getSourceLocation(), new Serializable[]{fid.getName()});
                }
                AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
                jobGenParams.readFromFuncArgs(f.getArguments());
                if (dataset.getDatasetName().compareTo(jobGenParams.datasetName) == 0) {
                    if (jobGenParams.isPrimaryIndex) {
                        primaryUnnestMapOps.add(unnestMapOp);
                    } else {
                        hasSecondaryIndexMap = true;
                        isIndexOnlyPlan = unnestMapOp.getGenerateCallBackProceedResultVar();
                    }
                }
            }
            queue.addAll(descendantOp.getInputs());
        }
        if (hasSecondaryIndexMap && !primaryUnnestMapOps.isEmpty()) {
            this.propagateFilterToPrimaryIndex(primaryUnnestMapOps, filterType, context, isIndexOnlyPlan);
        }
    }

    private Dataset getDataset(AbstractLogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator descendantOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        while (descendantOp != null) {
            UnnestMapOperator unnestMapOp;
            ILogicalExpression unnestExpr;
            if (descendantOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
                DataSourceScanOperator dataSourceScanOp = (DataSourceScanOperator)descendantOp;
                DataSource ds = (DataSource)dataSourceScanOp.getDataSource();
                if (ds.getDatasourceType() != 0) {
                    return null;
                }
                return ((DatasetDataSource)ds).getDataset();
            }
            if (descendantOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP && (unnestExpr = (ILogicalExpression)(unnestMapOp = (UnnestMapOperator)descendantOp).getExpressionRef().getValue()).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                String database;
                String datasetName;
                DataverseName dataverseName;
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
                FunctionIdentifier fid = f.getFunctionIdentifier();
                if (BuiltinFunctions.EXTERNAL_LOOKUP.equals((Object)fid)) {
                    dataverseName = DataverseName.createFromCanonicalForm((String)AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)f.getArguments().get(0))));
                    datasetName = AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)f.getArguments().get(1)));
                    database = AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)f.getArguments().get(2)));
                } else if (fid.equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
                    AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
                    jobGenParams.readFromFuncArgs(f.getArguments());
                    dataverseName = jobGenParams.dataverseName;
                    datasetName = jobGenParams.datasetName;
                    database = jobGenParams.databaseName;
                } else {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, f.getSourceLocation(), new Serializable[]{"Unexpected function for Unnest Map: " + fid});
                }
                return ((MetadataProvider)context.getMetadataProvider()).findDataset(database, dataverseName, datasetName);
            }
            if (descendantOp.getInputs().isEmpty()) break;
            descendantOp = (AbstractLogicalOperator)((Mutable)descendantOp.getInputs().get(0)).getValue();
        }
        return null;
    }

    private boolean checkIfRuleIsApplicable(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        ILogicalExpression condExpr = (ILogicalExpression)((SelectOperator)op).getCondition().getValue();
        return condExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL;
    }

    private AccessMethodAnalysisContext analyzeCondition(ILogicalExpression cond, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        AccessMethodAnalysisContext analysisCtx = new AccessMethodAnalysisContext();
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)cond;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent != AlgebricksBuiltinFunctions.OR) {
            this.analyzeFunctionExpr(funcExpr, analysisCtx, context, typeEnvironment);
            for (Mutable arg : funcExpr.getArguments()) {
                ILogicalExpression argExpr = (ILogicalExpression)arg.getValue();
                if (argExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
                this.analyzeFunctionExpr((AbstractFunctionCallExpression)argExpr, analysisCtx, context, typeEnvironment);
            }
        }
        return analysisCtx;
    }

    private void analyzeFunctionExpr(AbstractFunctionCallExpression funcExpr, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent == AlgebricksBuiltinFunctions.LE || funcIdent == AlgebricksBuiltinFunctions.GE || funcIdent == AlgebricksBuiltinFunctions.LT || funcIdent == AlgebricksBuiltinFunctions.GT || funcIdent == AlgebricksBuiltinFunctions.EQ) {
            AccessMethodUtils.analyzeFuncExprArgsForOneConstAndVarAndUpdateAnalysisCtx(funcExpr, analysisCtx, context, typeEnvironment, false);
        }
    }

    private boolean findMatchedExprFieldName(IOptimizableFuncExpr optFuncExpr, AbstractLogicalOperator op, Dataset dataset, ARecordType filterSourceType, List<Index> datasetIndexes, IOptimizationContext context, Integer filterSourceIndicator) throws AlgebricksException {
        AbstractLogicalOperator descendantOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        while (descendantOp != null) {
            int funcVarIndex;
            LogicalVariable var;
            int varIndex;
            List varList;
            if (descendantOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator assignOp = (AssignOperator)descendantOp;
                varList = assignOp.getVariables();
                for (varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    var = (LogicalVariable)varList.get(varIndex);
                    funcVarIndex = optFuncExpr.findLogicalVar(var);
                    if (funcVarIndex == -1) continue;
                    Pair<ARecordType, List<String>> fieldNamePairs = this.getFieldNameFromSubAssignTree(optFuncExpr, descendantOp, varIndex, filterSourceType, filterSourceIndicator, dataset.getPrimaryKeys().size());
                    if (fieldNamePairs == null) {
                        return false;
                    }
                    List fieldName = (List)fieldNamePairs.second;
                    optFuncExpr.setFieldName(funcVarIndex, fieldName, filterSourceIndicator);
                    return true;
                }
            } else if (descendantOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
                DataSourceScanOperator scanOp = (DataSourceScanOperator)descendantOp;
                varList = scanOp.getVariables();
                for (varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    var = (LogicalVariable)varList.get(varIndex);
                    funcVarIndex = optFuncExpr.findLogicalVar(var);
                    if (funcVarIndex == -1) continue;
                    List fieldName = (List)dataset.getPrimaryKeys().get(varIndex);
                    if (fieldName == null) {
                        return false;
                    }
                    List keySourceIndicators = DatasetUtil.getKeySourceIndicators((Dataset)dataset);
                    int keySource = IntroduceLSMComponentFilterRule.getKeySource(keySourceIndicators, varIndex);
                    optFuncExpr.setFieldName(funcVarIndex, fieldName, keySource);
                    return true;
                }
            } else if (descendantOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
                UnnestMapOperator unnestMapOp = (UnnestMapOperator)descendantOp;
                varList = unnestMapOp.getVariables();
                for (varIndex = 0; varIndex < varList.size(); ++varIndex) {
                    int keySource;
                    List fieldName;
                    ARecordType metaRecType;
                    var = (LogicalVariable)varList.get(varIndex);
                    funcVarIndex = optFuncExpr.findLogicalVar(var);
                    if (funcVarIndex == -1) continue;
                    Index index = null;
                    ILogicalExpression unnestExpr = (ILogicalExpression)unnestMapOp.getExpressionRef().getValue();
                    if (unnestExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
                        FunctionIdentifier fid = f.getFunctionIdentifier();
                        if (!fid.equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
                            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, unnestMapOp.getSourceLocation(), new Serializable[]{"Illegal function found, expected an index-search."});
                        }
                        AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
                        jobGenParams.readFromFuncArgs(f.getArguments());
                        String indexName = jobGenParams.indexName;
                        for (Index idx : datasetIndexes) {
                            if (idx.getIndexName().compareTo(indexName) != 0) continue;
                            index = idx;
                            break;
                        }
                    }
                    if (index == null) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, unnestMapOp.getSourceLocation(), new Serializable[]{"Could not find the corresponding index for an index search."});
                    }
                    IAType metaItemType = ((MetadataProvider)context.getMetadataProvider()).findType(dataset.getMetaItemTypeDatabaseName(), dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
                    IAType recordItemType = ((MetadataProvider)context.getMetadataProvider()).findType(dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
                    ARecordType recordType = (ARecordType)recordItemType;
                    int numSecondaryKeys = KeyFieldTypeUtil.getNumSecondaryKeys(index, (ARecordType)recordType, (ARecordType)(metaRecType = (ARecordType)metaItemType));
                    if (varIndex >= numSecondaryKeys) {
                        int idx = varIndex - numSecondaryKeys;
                        fieldName = (List)dataset.getPrimaryKeys().get(idx);
                        keySource = IntroduceLSMComponentFilterRule.getKeySource(DatasetUtil.getKeySourceIndicators((Dataset)dataset), idx);
                    } else {
                        ArrayList<Integer> keySources;
                        ArrayList<List> keyFieldNames;
                        switch (Index.IndexCategory.of((DatasetConfig.IndexType)index.getIndexType())) {
                            case ARRAY: {
                                Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
                                keyFieldNames = new ArrayList<List>();
                                keySources = new ArrayList<Integer>();
                                for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
                                    for (List project : e.getProjectList()) {
                                        keyFieldNames.add(ArrayIndexUtil.getFlattenedKeyFieldNames((List)e.getUnnestList(), (List)project));
                                        keySources.add(e.getSourceIndicator());
                                    }
                                }
                                break;
                            }
                            case VALUE: {
                                Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                                keyFieldNames = valueIndexDetails.getKeyFieldNames();
                                keySources = valueIndexDetails.getKeyFieldSourceIndicators();
                                break;
                            }
                            case TEXT: {
                                Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index.getIndexDetails();
                                keyFieldNames = textIndexDetails.getKeyFieldNames();
                                keySources = textIndexDetails.getKeyFieldSourceIndicators();
                                break;
                            }
                            default: {
                                throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{String.valueOf(index.getIndexType())});
                            }
                        }
                        fieldName = (List)keyFieldNames.get(varIndex);
                        keySource = IntroduceLSMComponentFilterRule.getKeySource(keySources, varIndex);
                    }
                    if (fieldName == null) {
                        return false;
                    }
                    optFuncExpr.setFieldName(funcVarIndex, fieldName, keySource);
                    return true;
                }
            }
            if (descendantOp.getInputs().isEmpty()) break;
            descendantOp = (AbstractLogicalOperator)((Mutable)descendantOp.getInputs().get(0)).getValue();
        }
        return false;
    }

    private static int getKeySource(List<Integer> keySourceIndicators, int keyIdx) {
        return keySourceIndicators == null ? 0 : keySourceIndicators.get(keyIdx);
    }

    private Pair<ARecordType, List<String>> getFieldNameFromSubAssignTree(IOptimizableFuncExpr optFuncExpr, AbstractLogicalOperator op, int varIndex, ARecordType filterSourceType, Integer filterSourceIndicator, int numOfPKeys) {
        ILogicalExpression argExpr;
        AbstractLogicalExpression expr = null;
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            expr = (AbstractLogicalExpression)((Mutable)assignOp.getExpressions().get(varIndex)).getValue();
        }
        if (expr == null || expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_NAME || funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_INDEX) {
            ArrayList usedVars = new ArrayList();
            expr.getUsedVariables(usedVars);
            LogicalVariable usedVar = (LogicalVariable)usedVars.get(0);
            List<String> returnList = new ArrayList<String>();
            for (int varCheck = 0; varCheck < op.getInputs().size(); ++varCheck) {
                Pair<ARecordType, List<String>> lowerInfo;
                AbstractLogicalOperator nestedOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(varCheck)).getValue();
                if (nestedOp.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
                    if (nestedOp.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
                        return null;
                    }
                    List scannedVars = ((DataSourceScanOperator)nestedOp).getScanVariables();
                    if (scannedVars.indexOf(usedVar) == filterSourceIndicator + numOfPKeys) continue;
                    return null;
                }
                int nestedAssignVar = ((AssignOperator)nestedOp).getVariables().indexOf(usedVar);
                if (nestedAssignVar == -1 || (lowerInfo = this.getFieldNameFromSubAssignTree(optFuncExpr, (AbstractLogicalOperator)((Mutable)op.getInputs().get(varCheck)).getValue(), nestedAssignVar, filterSourceType, filterSourceIndicator, numOfPKeys)) == null) continue;
                filterSourceType = (ARecordType)lowerInfo.first;
                returnList = (List)lowerInfo.second;
            }
            if (funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_NAME) {
                String fieldName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)1);
                if (fieldName == null) {
                    return null;
                }
                returnList.add(fieldName);
                return new Pair((Object)filterSourceType, returnList);
            }
            if (funcIdent == BuiltinFunctions.FIELD_ACCESS_BY_INDEX) {
                Integer fieldIndex = ConstantExpressionUtil.getIntArgument((AbstractFunctionCallExpression)funcExpr, (int)1);
                if (fieldIndex == null) {
                    return null;
                }
                returnList.add(filterSourceType.getFieldNames()[fieldIndex]);
                IAType subType = filterSourceType.getFieldTypes()[fieldIndex];
                if (subType.getTypeTag() == ATypeTag.OBJECT) {
                    filterSourceType = (ARecordType)subType;
                }
                return new Pair((Object)filterSourceType, returnList);
            }
        }
        if ((argExpr = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return null;
        }
        return null;
    }
}

