/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.processor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.column.filter.range.accessor.ConstantColumnRangeFilterValueAccessorFactory;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.UseDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.ColumnFilterPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.asterix.runtime.projection.ProjectionFiltrationWarningFactoryProvider;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ColumnRangeFilterPushdownProcessor
extends ColumnFilterPushdownProcessor {
    private final Map<String, FunctionCallInformation> sourceInformationMap = new HashMap<String, FunctionCallInformation>();

    public ColumnRangeFilterPushdownProcessor(PushdownContext pushdownContext, IOptimizationContext context) {
        super(pushdownContext, context);
    }

    @Override
    protected boolean skip(ScanDefineDescriptor scanDefineDescriptor) {
        Dataset dataset = scanDefineDescriptor.getDataset();
        return dataset.getDatasetFormatInfo().getFormat() != DatasetConfig.DatasetFormat.COLUMN || !DatasetUtil.isRangeFilterPushdownSupported((Dataset)dataset);
    }

    @Override
    protected void preparePushdown(UseDescriptor useDescriptor, ScanDefineDescriptor scanDescriptor) throws AlgebricksException {
        super.preparePushdown(useDescriptor, scanDescriptor);
        this.sourceInformationMap.clear();
    }

    @Override
    protected boolean isNotPushable(AbstractFunctionCallExpression expression) {
        return !PushdownUtil.RANGE_FILTER_PUSHABLE_FUNCTIONS.contains(expression.getFunctionIdentifier());
    }

    @Override
    protected boolean handleCompare(AbstractFunctionCallExpression expression) throws AlgebricksException {
        List args = expression.getArguments();
        Mutable leftRef = (Mutable)args.get(0);
        Mutable rightRef = (Mutable)args.get(1);
        ILogicalExpression left = (ILogicalExpression)leftRef.getValue();
        ILogicalExpression right = (ILogicalExpression)rightRef.getValue();
        if (PushdownUtil.isConstant((ILogicalExpression)left) && PushdownUtil.isFilterPath((ILogicalExpression)right)) {
            return this.pushdownRangeFilter(right, left, expression, true);
        }
        if (PushdownUtil.isConstant((ILogicalExpression)right) && PushdownUtil.isFilterPath((ILogicalExpression)left)) {
            return this.pushdownRangeFilter(left, right, expression, false);
        }
        return false;
    }

    @Override
    protected boolean handlePath(AbstractFunctionCallExpression expression) throws AlgebricksException {
        AnyExpectedSchemaNode node = this.getNode((ILogicalExpression)expression);
        ABoolean constantValue = ABoolean.TRUE;
        String functionName = expression.getFunctionIdentifier().getName();
        SourceLocation sourceLocation = expression.getSourceLocation();
        FunctionCallInformation functionCallInfo = new FunctionCallInformation(functionName, sourceLocation, ProjectionFiltrationWarningFactoryProvider.getIncomparableTypesFactory((boolean)false));
        ARecordType path = this.pathBuilderVisitor.buildPath(node, constantValue.getType(), this.sourceInformationMap, functionCallInfo);
        this.paths.put(expression, path);
        return true;
    }

    @Override
    protected void putFilterInformation(ScanDefineDescriptor scanDefineDescriptor, ILogicalExpression inlinedExpr) {
        ILogicalExpression filterExpr = scanDefineDescriptor.getRangeFilterExpression();
        if (filterExpr != null) {
            filterExpr = this.andExpression(filterExpr, inlinedExpr);
            scanDefineDescriptor.setRangeFilterExpression(filterExpr);
        } else {
            scanDefineDescriptor.setRangeFilterExpression(inlinedExpr);
        }
        scanDefineDescriptor.getFilterPaths().putAll(this.paths);
        scanDefineDescriptor.getPathLocations().putAll(this.sourceInformationMap);
    }

    private boolean pushdownRangeFilter(ILogicalExpression pathExpr, ILogicalExpression constExpr, AbstractFunctionCallExpression funcExpr, boolean leftConstant) throws AlgebricksException {
        AnyExpectedSchemaNode node = this.getNode(pathExpr);
        IAObject constantValue = ((AsterixConstantValue)((ConstantExpression)constExpr).getValue()).getObject();
        if (node == null || !ConstantColumnRangeFilterValueAccessorFactory.SUPPORTED_CONSTANT_TYPES.contains(constantValue.getType().getTypeTag())) {
            return false;
        }
        String functionName = funcExpr.getFunctionIdentifier().getName();
        SourceLocation sourceLocation = funcExpr.getSourceLocation();
        FunctionCallInformation functionCallInfo = new FunctionCallInformation(functionName, sourceLocation, ProjectionFiltrationWarningFactoryProvider.getIncomparableTypesFactory((boolean)leftConstant));
        ARecordType path = this.pathBuilderVisitor.buildPath(node, constantValue.getType(), this.sourceInformationMap, functionCallInfo);
        this.paths.put(pathExpr, path);
        return true;
    }

    private AnyExpectedSchemaNode getNode(ILogicalExpression expression) throws AlgebricksException {
        IExpectedSchemaNode node = (IExpectedSchemaNode)expression.accept((ILogicalExpressionVisitor)this.exprToNodeVisitor, null);
        if (node == null || node.getType() != ExpectedSchemaNodeType.ANY) {
            return null;
        }
        return (AnyExpectedSchemaNode)node;
    }
}

