/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.processor;

import java.util.List;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.DefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.UseDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.AbstractPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaBuilder;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.visitor.ExpressionValueAccessPushdownVisitor;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;

public class ColumnValueAccessPushdownProcessor
extends AbstractPushdownProcessor {
    private final ExpectedSchemaBuilder builder = new ExpectedSchemaBuilder();
    private final ExpressionValueAccessPushdownVisitor expressionVisitor = new ExpressionValueAccessPushdownVisitor(this.builder);

    public ColumnValueAccessPushdownProcessor(PushdownContext pushdownContext, IOptimizationContext context) {
        super(pushdownContext, context);
    }

    @Override
    public boolean process() throws AlgebricksException {
        List<ScanDefineDescriptor> scanDefineDescriptors = this.pushdownContext.getRegisteredScans();
        boolean changed = false;
        for (ScanDefineDescriptor scanDefineDescriptor : scanDefineDescriptors) {
            if (!DatasetUtil.isFieldAccessPushdownSupported((Dataset)scanDefineDescriptor.getDataset())) continue;
            this.pushdownFieldAccessForDataset(scanDefineDescriptor);
            RootExpectedSchemaNode root = (RootExpectedSchemaNode)this.builder.getNode(scanDefineDescriptor.getVariable());
            scanDefineDescriptor.setRecordNode(root);
            changed |= !root.isAllFields();
            if (!scanDefineDescriptor.hasMeta()) continue;
            RootExpectedSchemaNode metaRoot = (RootExpectedSchemaNode)this.builder.getNode(scanDefineDescriptor.getMetaRecordVariable());
            changed |= !metaRoot.isAllFields();
            scanDefineDescriptor.setMetaNode(metaRoot);
        }
        return changed;
    }

    private void pushdownFieldAccessForDataset(ScanDefineDescriptor scanDefineDescriptor) throws AlgebricksException {
        this.builder.registerRoot(scanDefineDescriptor.getVariable(), scanDefineDescriptor.getRecordNode());
        if (scanDefineDescriptor.hasMeta()) {
            this.builder.registerRoot(scanDefineDescriptor.getMetaRecordVariable(), scanDefineDescriptor.getMetaNode());
        }
        this.pushdownFieldAccess(scanDefineDescriptor);
    }

    private void pushdownFieldAccess(DefineDescriptor defineDescriptor) throws AlgebricksException {
        List<UseDescriptor> useDescriptors = this.pushdownContext.getUseDescriptors(defineDescriptor);
        for (UseDescriptor useDescriptor : useDescriptors) {
            LogicalVariable producedVariable = useDescriptor.getProducedVariable();
            ILogicalOperator op = useDescriptor.getOperator();
            if (this.isDelete(op)) continue;
            IVariableTypeEnvironment typeEnv = PushdownUtil.getTypeEnv((ILogicalOperator)op, (IOptimizationContext)this.context);
            this.expressionVisitor.transform(useDescriptor.getExpression(), producedVariable, typeEnv);
        }
        for (UseDescriptor useDescriptor : useDescriptors) {
            DefineDescriptor nextDefineDescriptor = this.pushdownContext.getDefineDescriptor(useDescriptor);
            if (nextDefineDescriptor == null) continue;
            this.pushdownFieldAccess(nextDefineDescriptor);
        }
    }

    private boolean isDelete(ILogicalOperator op) {
        if (op.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            return false;
        }
        InsertDeleteUpsertOperator deleteOp = (InsertDeleteUpsertOperator)op;
        return deleteOp.getOperation() == InsertDeleteUpsertOperator.Kind.DELETE;
    }
}

