/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.AnalyzeDropStatement;
import org.apache.asterix.lang.common.statement.AnalyzeStatement;
import org.apache.asterix.lang.common.statement.CreateAdapterStatement;
import org.apache.asterix.lang.common.statement.CreateDatabaseStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateLibraryStatement;
import org.apache.asterix.lang.common.statement.CreateSynonymStatement;
import org.apache.asterix.lang.common.statement.CreateViewStatement;
import org.apache.asterix.lang.common.statement.DatabaseDropStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLangTranslator {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String INVALID_OPERATION_MESSAGE = "Invalid operation - %s";
    protected static final String BAD_DATAVERSE_DML_MESSAGE = "%s operation is not permitted in " + IdentifierUtil.dataverse() + " %s";
    protected static final String BAD_DATAVERSE_DML_MSG_DB = "%s operation is not permitted in " + IdentifierUtil.dataverse() + " %s in database %s";
    protected static final String BAD_DATAVERSE_DDL_MESSAGE = "Cannot %s " + IdentifierUtil.dataverse() + ": %s";
    protected static final String BAD_DATAVERSE_DDL_MSG_DB = "Cannot %s " + IdentifierUtil.dataverse() + ": %s in database: %s";
    protected static final String BAD_DATAVERSE_OBJECT_DDL_MESSAGE = "Cannot %s a %s belonging to the " + IdentifierUtil.dataverse() + ": %s";
    protected static final String BAD_DATAVERSE_OBJECT_DDL_MSG_DB = "Cannot %s a %s belonging to the " + IdentifierUtil.dataverse() + ": %s in database: %s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOperation(ICcApplicationContext appCtx, Namespace activeNamespace, Statement stmt) throws AlgebricksException {
        int maxWaitCycles;
        IClusterStateManager clusterStateManager = appCtx.getClusterStateManager();
        IGlobalRecoveryManager globalRecoveryManager = appCtx.getGlobalRecoveryManager();
        if (!clusterStateManager.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE) || !globalRecoveryManager.isRecoveryCompleted()) {
            maxWaitCycles = appCtx.getExternalProperties().getMaxWaitClusterActive();
            try {
                clusterStateManager.waitForState(IClusterManagementWork.ClusterState.ACTIVE, (long)maxWaitCycles, TimeUnit.SECONDS);
            }
            catch (HyracksDataException e) {
                throw new AlgebricksException((Throwable)e, ErrorCode.TIMEOUT, new Serializable[0]);
            }
            catch (InterruptedException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Thread interrupted while waiting for cluster to be " + IClusterManagementWork.ClusterState.ACTIVE);
                }
                Thread.currentThread().interrupt();
            }
            IClusterStateManager e = clusterStateManager;
            synchronized (e) {
                if (!clusterStateManager.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE)) {
                    ClusterPartition[] configuredPartitions = clusterStateManager.getClusterPartitons();
                    HashSet<String> inactiveNodes = new HashSet<String>();
                    for (ClusterPartition cp : configuredPartitions) {
                        if (cp.isActive()) continue;
                        inactiveNodes.add(cp.getNodeId());
                    }
                    throw AsterixException.create((org.apache.asterix.common.exceptions.ErrorCode)org.apache.asterix.common.exceptions.ErrorCode.CLUSTER_STATE_UNUSABLE, (Serializable[])new Serializable[]{Arrays.toString(inactiveNodes.toArray())});
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Cluster is now " + IClusterManagementWork.ClusterState.ACTIVE);
                }
            }
        }
        if (!globalRecoveryManager.isRecoveryCompleted()) {
            maxWaitCycles = appCtx.getExternalProperties().getMaxWaitClusterActive();
            try {
                for (int waitCycleCount = 0; !globalRecoveryManager.isRecoveryCompleted() && waitCycleCount < maxWaitCycles; ++waitCycleCount) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Thread interrupted while waiting for cluster to complete global recovery ");
                }
                Thread.currentThread().interrupt();
            }
            if (!globalRecoveryManager.isRecoveryCompleted()) {
                throw new AsterixException("Cluster Global recovery is not yet complete and the system is in " + IClusterManagementWork.ClusterState.ACTIVE + " state");
            }
        }
        boolean usingDb = appCtx.getNamespaceResolver().isUsingDatabase();
        boolean invalidOperation = false;
        String message = null;
        switch (stmt.getKind()) {
            case LOAD: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((LoadStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatDmlMessage("Load", namespace, usingDb);
                break;
            }
            case INSERT: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((InsertStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatDmlMessage("Insert", namespace, usingDb);
                break;
            }
            case UPSERT: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((UpsertStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatDmlMessage("Upsert", namespace, usingDb);
                break;
            }
            case DELETE: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((DeleteStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatDmlMessage("Delete", namespace, usingDb);
                break;
            }
            case CREATE_DATABASE: {
                CreateDatabaseStatement dbCreateStmt = (CreateDatabaseStatement)stmt;
                String dbName = dbCreateStmt.getDatabaseName().getValue();
                boolean bl = invalidOperation = AbstractLangTranslator.isSystemDatabase(dbName) || AbstractLangTranslator.isDefaultDatabase(dbName) || AbstractLangTranslator.isReservedDatabase(dbName);
                if (!invalidOperation) break;
                message = String.format("Cannot create database: %s", dbName);
                break;
            }
            case DATABASE_DROP: {
                DatabaseDropStatement dbDropStmt = (DatabaseDropStatement)stmt;
                String dbName = dbDropStmt.getDatabaseName().getValue();
                boolean bl = invalidOperation = AbstractLangTranslator.isSystemDatabase(dbName) || AbstractLangTranslator.isDefaultDatabase(dbName);
                if (!invalidOperation) break;
                message = String.format("Cannot drop database: %s", dbName);
                break;
            }
            case CREATE_DATAVERSE: {
                CreateDataverseStatement dvCreateStmt = (CreateDataverseStatement)stmt;
                DataverseName dataverseName = dvCreateStmt.getDataverseName();
                boolean bl = invalidOperation = FunctionConstants.ASTERIX_DV.equals((Object)dataverseName) || FunctionConstants.ALGEBRICKS_DV.equals((Object)dataverseName) || AbstractLangTranslator.isMetadataDataverse(dataverseName) || AbstractLangTranslator.isDefaultDataverse(dataverseName) || AbstractLangTranslator.isSystemDatabase(dvCreateStmt.getDatabaseName());
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatDdlMessage("create", dataverseName, dvCreateStmt.getDatabaseName(), usingDb);
                break;
            }
            case DATAVERSE_DROP: {
                DataverseDropStatement dvDropStmt = (DataverseDropStatement)stmt;
                DataverseName dataverseName = dvDropStmt.getDataverseName();
                boolean bl = invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName) || AbstractLangTranslator.isDefaultDataverse(dataverseName) || AbstractLangTranslator.isSystemDatabase(dvDropStmt.getDatabaseName());
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatDdlMessage("drop", dataverseName, dvDropStmt.getDatabaseName(), usingDb);
                break;
            }
            case DATASET_DECL: {
                Map hints;
                DatasetDecl dsCreateStmt = (DatasetDecl)stmt;
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((DatasetDecl)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (invalidOperation) {
                    message = AbstractLangTranslator.formatObjectDdlMessage("create", IdentifierUtil.dataset(), namespace, usingDb);
                }
                if (invalidOperation || (hints = dsCreateStmt.getHints()) == null || hints.isEmpty()) break;
                StringBuilder errorMsgBuffer = new StringBuilder();
                for (Map.Entry hint : hints.entrySet()) {
                    Pair validationResult = DatasetHints.validate((ICcApplicationContext)appCtx, (String)((String)hint.getKey()), (String)((String)hint.getValue()));
                    if (((Boolean)validationResult.first).booleanValue()) continue;
                    errorMsgBuffer.append(StringUtils.capitalize((String)IdentifierUtil.dataset())).append(": ").append(dsCreateStmt.getName().getValue()).append(" error in processing hint: ").append((String)hint.getKey()).append(" ").append((String)validationResult.second);
                    errorMsgBuffer.append(" \n");
                }
                boolean bl = invalidOperation = errorMsgBuffer.length() > 0;
                if (!invalidOperation) break;
                message = errorMsgBuffer.toString();
                break;
            }
            case DATASET_DROP: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((DropDatasetStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("drop", IdentifierUtil.dataset(), namespace, usingDb);
                break;
            }
            case INDEX_DROP: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((IndexDropStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("drop", "index", namespace, usingDb);
                break;
            }
            case TYPE_DECL: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((TypeDecl)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "type", namespace, usingDb);
                break;
            }
            case TYPE_DROP: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((TypeDropStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("drop", "type", namespace, usingDb);
                break;
            }
            case CREATE_SYNONYM: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((CreateSynonymStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "synonym", namespace, usingDb);
                break;
            }
            case FUNCTION_DECL: {
                FunctionDecl fnDeclStmt = (FunctionDecl)stmt;
                FunctionSignature fnDeclSignature = fnDeclStmt.getSignature();
                Namespace namespace = fnDeclSignature.getDataverseName() != null ? new Namespace(fnDeclSignature.getDatabaseName(), fnDeclSignature.getDataverseName()) : activeNamespace;
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("declare", "function", namespace, usingDb);
                break;
            }
            case CREATE_FUNCTION: {
                CreateFunctionStatement fnCreateStmt = (CreateFunctionStatement)stmt;
                FunctionSignature fnCreateSignature = fnCreateStmt.getFunctionSignature();
                Namespace namespace = fnCreateSignature.getDataverseName() != null ? new Namespace(fnCreateSignature.getDatabaseName(), fnCreateSignature.getDataverseName()) : activeNamespace;
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "function", namespace, usingDb);
                break;
            }
            case CREATE_LIBRARY: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((CreateLibraryStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "library", namespace, usingDb);
                break;
            }
            case CREATE_ADAPTER: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((CreateAdapterStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "adapter", namespace, usingDb);
                break;
            }
            case CREATE_VIEW: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((CreateViewStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "view", namespace, usingDb);
                break;
            }
            case CREATE_FEED: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((CreateFeedStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "feed", namespace, usingDb);
                break;
            }
            case CREATE_FEED_POLICY: {
                invalidOperation = AbstractLangTranslator.isSystemNamespace(activeNamespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("create", "ingestion policy", activeNamespace, usingDb);
                break;
            }
            case ANALYZE: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((AnalyzeStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("analyze", IdentifierUtil.dataset(), namespace, usingDb);
                break;
            }
            case ANALYZE_DROP: {
                Namespace namespace = AbstractLangTranslator.getStatementNamespace(((AnalyzeDropStatement)stmt).getNamespace(), activeNamespace);
                invalidOperation = AbstractLangTranslator.isSystemNamespace(namespace);
                if (!invalidOperation) break;
                message = AbstractLangTranslator.formatObjectDdlMessage("analyze drop", IdentifierUtil.dataset(), namespace, usingDb);
            }
        }
        if (invalidOperation) {
            throw new CompilationException(org.apache.asterix.common.exceptions.ErrorCode.COMPILATION_ERROR, stmt.getSourceLocation(), new Serializable[]{String.format(INVALID_OPERATION_MESSAGE, message)});
        }
    }

    private static String formatDmlMessage(String operation, Namespace ns, boolean usingDb) {
        DataverseName dv = ns.getDataverseName();
        return usingDb ? String.format(BAD_DATAVERSE_DML_MSG_DB, operation, dv, ns.getDatabaseName()) : String.format(BAD_DATAVERSE_DML_MESSAGE, operation, dv);
    }

    private static String formatDdlMessage(String operation, DataverseName dv, String db, boolean usingDb) {
        return usingDb ? String.format(BAD_DATAVERSE_DDL_MSG_DB, operation, dv, db) : String.format(BAD_DATAVERSE_DDL_MESSAGE, operation, dv);
    }

    protected static String formatObjectDdlMessage(String operation, String object, Namespace ns, boolean usingDb) {
        DataverseName dv = ns.getDataverseName();
        return usingDb ? String.format(BAD_DATAVERSE_OBJECT_DDL_MSG_DB, operation, object, dv, ns.getDatabaseName()) : String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, operation, object, dv);
    }

    protected static Namespace getStatementNamespace(Namespace namespace, Namespace activeNamespace) {
        return namespace != null ? namespace : activeNamespace;
    }

    protected static boolean isSystemNamespace(Namespace ns) {
        return ns != null && (AbstractLangTranslator.isSystemDatabase(ns.getDatabaseName()) || AbstractLangTranslator.isMetadataDataverse(ns.getDataverseName()));
    }

    protected static boolean isSystemDatabase(String databaseName) {
        return "System".equals(databaseName);
    }

    protected static boolean isDefaultDatabase(String databaseName) {
        return "Default".equals(databaseName);
    }

    protected static boolean isMetadataDataverse(DataverseName dataverseName) {
        return MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dataverseName);
    }

    protected static boolean isDefaultDataverse(DataverseName dataverseName) {
        return MetadataConstants.DEFAULT_DATAVERSE_NAME.equals((Object)dataverseName);
    }

    protected static boolean isReservedDatabase(String databaseName) {
        return "asterix".equals(databaseName) || "algebricks".equals(databaseName) || MetadataConstants.METADATA_DATAVERSE_NAME.getCanonicalForm().equals(databaseName) || databaseName.startsWith("partition_");
    }
}

