/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.statement.CreateViewStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinTypeMap;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.util.LogRedactionUtil;

public class ValidateUtil {
    private static final String PRIMARY = "primary";

    private ValidateUtil() {
    }

    public static void validateFilterField(ARecordType recordType, ARecordType metaType, Integer filterSourceIndicator, List<String> filterField, SourceLocation sourceLoc) throws AlgebricksException {
        ARecordType itemType = filterSourceIndicator == 0 ? recordType : metaType;
        IAType fieldType = itemType.getSubFieldType(filterField);
        if (fieldType == null) {
            throw new CompilationException(ErrorCode.COMPILATION_FIELD_NOT_FOUND, sourceLoc, new Serializable[]{LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(filterField))});
        }
        switch (fieldType.getTypeTag()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case UUID: 
            case YEARMONTHDURATION: 
            case DAYTIMEDURATION: {
                break;
            }
            case UNION: {
                throw new CompilationException(ErrorCode.COMPILATION_FILTER_CANNOT_BE_NULLABLE, new Serializable[]{LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(filterField))});
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_FILTER_TYPE, new Serializable[]{fieldType.getTypeTag().name()});
            }
        }
    }

    public static List<IAType> validatePartitioningExpressions(ARecordType recType, ARecordType metaRecType, List<List<String>> partitioningExprs, List<Integer> keySourceIndicators, boolean autogenerated, SourceLocation sourceLoc, List<TypeExpression> partitioningExprTypes) throws AlgebricksException {
        return ValidateUtil.validatePartitioningExpressionsImpl(recType, metaRecType, partitioningExprs, keySourceIndicators, autogenerated, true, sourceLoc, partitioningExprTypes);
    }

    private static List<IAType> validatePartitioningExpressionsImpl(ARecordType recType, ARecordType metaRecType, List<List<String>> partitioningExprs, List<Integer> keySourceIndicators, boolean autogenerated, boolean forPrimaryKey, SourceLocation sourceLoc, List<TypeExpression> partitioningExprTypes) throws AlgebricksException {
        String keyKindDisplayName = forPrimaryKey ? PRIMARY : "";
        ArrayList<IAType> computedPartitioningExprTypes = new ArrayList(partitioningExprs.size());
        if (autogenerated) {
            if (partitioningExprs.size() > 1) {
                throw new CompilationException(ErrorCode.COMPILATION_CANNOT_AUTOGENERATE_COMPOSITE_KEY, sourceLoc, new Serializable[]{keyKindDisplayName});
            }
            List<String> fieldName = partitioningExprs.get(0);
            IAType fieldType = recType.getSubFieldType(fieldName);
            if (fieldType == null) {
                if (partitioningExprTypes != null && partitioningExprTypes.size() > 0) {
                    String typeName = ((Identifier)((TypeReferenceExpression)partitioningExprTypes.get((int)0)).getIdent().second).getValue();
                    fieldType = BuiltinTypeMap.getBuiltinType((String)typeName);
                    if (fieldType == null) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_KEY_TYPE, sourceLoc, new Serializable[]{typeName, keyKindDisplayName});
                    }
                } else {
                    String unTypeField = fieldName.get(0) == null ? "" : fieldName.get(0);
                    throw new CompilationException(ErrorCode.COMPILATION_FIELD_NOT_FOUND, sourceLoc, new Serializable[]{LogRedactionUtil.userData((String)unTypeField)});
                }
            }
            computedPartitioningExprTypes.add(fieldType);
            ATypeTag pkTypeTag = fieldType.getTypeTag();
            if (pkTypeTag != ATypeTag.UUID) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_AUTOGENERATED_TYPE, sourceLoc, new Serializable[]{keyKindDisplayName, pkTypeTag.name(), ATypeTag.UUID.name()});
            }
        } else {
            if (partitioningExprTypes == null) {
                computedPartitioningExprTypes = KeyFieldTypeUtil.getKeyTypes((ARecordType)recType, (ARecordType)metaRecType, partitioningExprs, keySourceIndicators);
            }
            block4: for (int i = 0; i < partitioningExprs.size(); ++i) {
                IAType fieldType;
                List<String> partitioningExpr = partitioningExprs.get(i);
                if (partitioningExprTypes != null) {
                    String typeName = ((Identifier)((TypeReferenceExpression)partitioningExprTypes.get((int)i)).getIdent().second).getValue();
                    fieldType = BuiltinTypeMap.getBuiltinType((String)typeName);
                    if (fieldType == null) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_KEY_TYPE, sourceLoc, new Serializable[]{typeName, keyKindDisplayName});
                    }
                    computedPartitioningExprTypes.add(fieldType);
                } else {
                    fieldType = (IAType)computedPartitioningExprTypes.get(i);
                    if (fieldType == null) {
                        throw new CompilationException(ErrorCode.COMPILATION_FIELD_NOT_FOUND, sourceLoc, new Serializable[]{LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(partitioningExpr))});
                    }
                    if (forPrimaryKey) {
                        boolean nullable = KeyFieldTypeUtil.chooseSource(keySourceIndicators, (int)i, (ARecordType)recType, (ARecordType)metaRecType).isSubFieldNullable(partitioningExpr);
                        if (nullable) {
                            throw new CompilationException(ErrorCode.COMPILATION_KEY_CANNOT_BE_NULLABLE, sourceLoc, new Serializable[]{keyKindDisplayName, LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(partitioningExpr))});
                        }
                    } else {
                        fieldType = TypeComputeUtils.getActualType((IAType)fieldType);
                    }
                }
                switch (fieldType.getTypeTag()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: 
                    case BINARY: 
                    case DATE: 
                    case TIME: 
                    case DATETIME: 
                    case UUID: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: {
                        continue block4;
                    }
                    case UNION: {
                        throw new CompilationException(ErrorCode.COMPILATION_KEY_CANNOT_BE_NULLABLE, sourceLoc, new Serializable[]{keyKindDisplayName, LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(partitioningExpr))});
                    }
                    default: {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_KEY_TYPE, sourceLoc, new Serializable[]{fieldType.getTypeTag(), keyKindDisplayName});
                    }
                }
            }
        }
        return computedPartitioningExprTypes;
    }

    public static void validateIndexFieldType(DatasetConfig.IndexType indexType, IAType fieldType, List<String> displayFieldName, SourceLocation sourceLoc) throws AlgebricksException {
        block0 : switch (indexType) {
            case ARRAY: 
            case BTREE: {
                switch (fieldType.getTypeTag()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: 
                    case BINARY: 
                    case DATE: 
                    case TIME: 
                    case DATETIME: 
                    case UUID: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field '" + LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(displayFieldName)) + "' which is of type " + fieldType.getTypeTag() + " cannot be indexed using the BTree index."});
            }
            case RTREE: {
                switch (fieldType.getTypeTag()) {
                    case POINT: 
                    case LINE: 
                    case RECTANGLE: 
                    case CIRCLE: 
                    case POLYGON: 
                    case GEOMETRY: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field '" + LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(displayFieldName)) + "' which is of type " + fieldType.getTypeTag() + " cannot be indexed using the RTree index."});
            }
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                if (fieldType.getTypeTag() == ATypeTag.STRING) break;
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field '" + LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(displayFieldName)) + "' which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Length Partitioned N-Gram index."});
            }
            case LENGTH_PARTITIONED_WORD_INVIX: {
                switch (fieldType.getTypeTag()) {
                    case STRING: 
                    case MULTISET: 
                    case ARRAY: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field '" + LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(displayFieldName)) + "' which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Length Partitioned Keyword index."});
            }
            case SINGLE_PARTITION_NGRAM_INVIX: {
                if (fieldType.getTypeTag() == ATypeTag.STRING) break;
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field '" + LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(displayFieldName)) + "' which is of type " + fieldType.getTypeTag() + " cannot be indexed using the N-Gram index."});
            }
            case SINGLE_PARTITION_WORD_INVIX: {
                switch (fieldType.getTypeTag()) {
                    case STRING: 
                    case MULTISET: 
                    case ARRAY: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field '" + LogRedactionUtil.userData((String)RecordUtil.toFullyQualifiedName(displayFieldName)) + "' which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Keyword index."});
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, sourceLoc, new Serializable[]{String.valueOf(indexType)});
            }
        }
    }

    public static List<String> validateViewKeyFields(CreateViewStatement.KeyDecl keyDecl, ARecordType itemType, boolean isForeignKey, SourceLocation sourceLoc) throws AlgebricksException {
        List sourceIndicators = keyDecl.getSourceIndicators();
        List fields = keyDecl.getFields();
        int n = fields.size();
        ArrayList<String> keyFields = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            if ((Integer)sourceIndicators.get(i) != 0) {
                throw new CompilationException(isForeignKey ? ErrorCode.INVALID_FOREIGN_KEY_DEFINITION : ErrorCode.INVALID_PRIMARY_KEY_DEFINITION, sourceLoc, new Serializable[0]);
            }
            List nestedField = (List)fields.get(i);
            if (nestedField.size() != 1) {
                throw new CompilationException(isForeignKey ? ErrorCode.INVALID_FOREIGN_KEY_DEFINITION : ErrorCode.INVALID_PRIMARY_KEY_DEFINITION, sourceLoc, new Serializable[0]);
            }
            keyFields.add((String)nestedField.get(0));
        }
        ValidateUtil.validatePartitioningExpressionsImpl(itemType, null, keyFields.stream().map(Collections::singletonList).collect(Collectors.toList()), Collections.nCopies(keyFields.size(), 0), false, !isForeignKey, sourceLoc, null);
        return keyFields;
    }
}

