/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.clients.profiler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.cloud.clients.profiler.IRequestProfiler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CountRequestProfiler
implements IRequestProfiler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LogManager.getLogger();
    private final long logInterval;
    private final AtomicLong listObjectsCounter;
    private final AtomicLong getObjectCounter;
    private final AtomicLong writeObjectCounter;
    private final AtomicLong deleteObjectCounter;
    private final AtomicLong copyObjectCounter;
    private final AtomicLong multipartUploadCounter;
    private final AtomicLong multipartDownloadCounter;
    private long lastLogTimestamp;

    public CountRequestProfiler(long logIntervalNanoSec) {
        this.logInterval = logIntervalNanoSec;
        this.listObjectsCounter = new AtomicLong();
        this.getObjectCounter = new AtomicLong();
        this.writeObjectCounter = new AtomicLong();
        this.deleteObjectCounter = new AtomicLong();
        this.copyObjectCounter = new AtomicLong();
        this.multipartUploadCounter = new AtomicLong();
        this.multipartDownloadCounter = new AtomicLong();
        this.lastLogTimestamp = System.nanoTime();
    }

    @Override
    public void objectsList() {
        this.listObjectsCounter.incrementAndGet();
        this.log();
    }

    @Override
    public void objectGet() {
        this.getObjectCounter.incrementAndGet();
        this.log();
    }

    @Override
    public void objectWrite() {
        this.writeObjectCounter.incrementAndGet();
        this.log();
    }

    @Override
    public void objectDelete() {
        this.deleteObjectCounter.incrementAndGet();
        this.log();
    }

    @Override
    public void objectCopy() {
        this.copyObjectCounter.incrementAndGet();
        this.log();
    }

    @Override
    public void objectMultipartUpload() {
        this.multipartUploadCounter.incrementAndGet();
        this.log();
    }

    @Override
    public void objectMultipartDownload() {
        this.multipartDownloadCounter.incrementAndGet();
        this.log();
    }

    private void log() {
        long currentTime = System.nanoTime();
        if (currentTime - this.lastLogTimestamp >= this.logInterval) {
            this.lastLogTimestamp = currentTime;
            ObjectNode countersNode = OBJECT_MAPPER.createObjectNode();
            countersNode.put("listObjectsCounter", this.listObjectsCounter.get());
            countersNode.put("getObjectCounter", this.getObjectCounter.get());
            countersNode.put("writeObjectCounter", this.writeObjectCounter.get());
            countersNode.put("deleteObjectCounter", this.deleteObjectCounter.get());
            countersNode.put("copyObjectCounter", this.copyObjectCounter.get());
            countersNode.put("multipartUploadCounter", this.multipartUploadCounter.get());
            countersNode.put("multipartDownloadCounter", this.multipartDownloadCounter.get());
            LOGGER.debug("Cloud request counters: {}", (Object)countersNode.toString());
        }
    }
}

